# Generated by Django 3.1.13 on 2021-10-27 16:51

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import photoalbum.files.models


class Migration(migrations.Migration):

    dependencies = [
        ("files", "0003_rename_models"),
    ]

    operations = [
        migrations.CreateModel(
            name="MediaFile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "resource_id",
                    models.CharField(
                        blank=True,
                        help_text="Поле resource_id из Я.Диска",
                        max_length=255,
                        unique=True,
                        verbose_name="resource id",
                    ),
                ),
                (
                    "filename",
                    models.CharField(max_length=255, verbose_name="имя файла"),
                ),
                ("path", models.CharField(max_length=1024, verbose_name="путь")),
                (
                    "size",
                    models.PositiveBigIntegerField(default=0, verbose_name="размер"),
                ),
                (
                    "file",
                    models.FileField(
                        blank=True,
                        null=True,
                        upload_to=photoalbum.files.models.get_upload_path,
                        verbose_name="файл",
                    ),
                ),
                (
                    "chksum",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="хеш сумма"
                    ),
                ),
                (
                    "media_type",
                    models.CharField(max_length=255, verbose_name="тип медиа"),
                ),
                (
                    "mime_type",
                    models.CharField(max_length=255, verbose_name="тип файла"),
                ),
                (
                    "extra_info",
                    models.JSONField(
                        default=dict, verbose_name="дополнительная информация"
                    ),
                ),
                ("tags", models.ManyToManyField(to="files.Tag", verbose_name="теги")),
            ],
            options={
                "verbose_name": "медиа",
                "verbose_name_plural": "медиа",
            },
        ),
        migrations.CreateModel(
            name="Photo",
            fields=[
                (
                    "mediafile_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="files.mediafile",
                    ),
                ),
                ("exif", models.JSONField(default=dict, verbose_name="EXIF")),
                (
                    "geo_coords",
                    models.CharField(
                        max_length=255, null=True, verbose_name="гео-координаты"
                    ),
                ),
                ("photo_date", models.DateTimeField(verbose_name="дата съёмки")),
                (
                    "preview",
                    models.ImageField(
                        blank=True,
                        max_length=1024,
                        null=True,
                        upload_to=photoalbum.files.models.get_preview_upload_path,
                        verbose_name="превью",
                    ),
                ),
            ],
            options={
                "verbose_name": "фото",
                "verbose_name_plural": "фото",
            },
            bases=("files.mediafile", models.Model),
        ),
        migrations.CreateModel(
            name="Video",
            fields=[
                (
                    "mediafile_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="files.mediafile",
                    ),
                ),
                ("exif", models.JSONField(default=dict, verbose_name="EXIF")),
                ("video_date", models.DateTimeField(verbose_name="дата съёмки")),
            ],
            options={
                "verbose_name": "видео",
                "verbose_name_plural": "видео",
            },
            bases=("files.mediafile", models.Model),
        ),
    ]
