# Generated by Django 3.1.13 on 2021-12-14 15:13

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import mptt.fields


class Migration(migrations.Migration):

    dependencies = [
        ("files", "0008_add_location"),
    ]

    operations = [
        migrations.CreateModel(
            name="Folder",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "resource_id",
                    models.CharField(
                        blank=True,
                        help_text="Поле resource_id из Я.Диска",
                        max_length=255,
                        unique=True,
                        verbose_name="resource id",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="имя папки")),
                ("path", models.CharField(max_length=1024, verbose_name="путь")),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="files.folder",
                    ),
                ),
            ],
            options={
                "verbose_name": "папка",
                "verbose_name_plural": "папки",
            },
        ),
        migrations.AddField(
            model_name="mediafile",
            name="folder",
            field=mptt.fields.TreeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="files.folder",
                verbose_name="папка",
            ),
        ),
    ]
