# Generated by Django 3.1.13 on 2022-06-01 15:08

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("files", "0013_photo_detected"),
    ]

    operations = [
        migrations.CreateModel(
            name="Copyright",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("name", models.CharField(max_length=255, verbose_name="права")),
                (
                    "slug",
                    models.SlugField(max_length=255, unique=True, verbose_name="код"),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="активно"),
                ),
            ],
            options={
                "verbose_name": "права",
                "verbose_name_plural": "права",
            },
        ),
        migrations.AddField(
            model_name="mediafile",
            name="rights_comment",
            field=models.TextField(blank=True, verbose_name="комментарий по правам"),
        ),
        migrations.AddField(
            model_name="mediafile",
            name="uploaded_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="uploaded_files",
                to=settings.AUTH_USER_MODEL,
                verbose_name="кем загружено",
            ),
        ),
        migrations.CreateModel(
            name="Author",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(blank=True, max_length=255, verbose_name="имя"),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="фамилия"
                    ),
                ),
                (
                    "email",
                    models.CharField(blank=True, max_length=255, verbose_name="почта"),
                ),
                (
                    "phone_number",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="телефон"
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="пользователь",
                    ),
                ),
            ],
            options={
                "verbose_name": "автор",
                "verbose_name_plural": "авторы",
            },
        ),
        migrations.AddField(
            model_name="mediafile",
            name="author",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="files",
                to="files.author",
                verbose_name="автор",
            ),
        ),
        migrations.AddField(
            model_name="mediafile",
            name="copyright",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="files",
                to="files.copyright",
                verbose_name="права",
            ),
        ),
    ]
