package ru.yandex.qe.dispenser.api;

import java.util.List;
import java.util.Map;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DiRequest<T> {
    @NotNull
    String getMethod();

    @NotNull
    Map<String, List<String>> getHeaders();

    @Nullable
    String getFirstHeader(String name);

    @NotNull
    String getPath();

    @NotNull
    String getFullUrl();

    @Nullable
    String getQueryParam(@NotNull String paramName);

    @Nullable
    T getBody();

    void setHeader(String name, String value);
}
