package ru.yandex.qe.dispenser.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;


public abstract class KeyBase<K extends Comparable<K>> implements Keyable<K> {
    @NotNull
    private final K key;

    protected KeyBase(@NotNull final K key) {
        this.key = key;
    }

    protected KeyBase(@NotNull final Builder<K, ?> builder) {
        this.key = builder.key;
    }

    @NotNull
    @Override
    public final K getKey() {
        return key;
    }

    @Override
    public boolean equals(@Nullable final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        return key.equals(((KeyBase<?>) o).key);
    }

    @Override
    public int hashCode() {
        return key.hashCode();
    }

    @Override
    public String toString() {
        return "KeyBase{key=" + key + "}";
    }

    protected abstract static class Builder<K, B extends Builder<K, B>> {
        @NotNull
        protected final K key;

        protected Builder(@NotNull final K key) {
            this.key = key;
        }

        @NotNull
        public K getKey() {
            return key;
        }

        @NotNull
        @SuppressWarnings("unchecked")
        protected final B self() {
            return (B) this;
        }
    }
}
