package ru.yandex.qe.dispenser.api;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Keyable<K extends Comparable<? super K>> extends Comparable<Keyable<? extends K>> {
    @NotNull
    K getKey();

    @Override
    default int compareTo(@NotNull final Keyable<? extends K> other) {
        return getKey().compareTo(other.getKey());
    }

    boolean equals(@Nullable Object o);

    int hashCode();

}
