package ru.yandex.qe.dispenser.api.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

/**
 * Enum utils.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public final class EnumUtils {
    private EnumUtils() {
    }

    public static <V extends StringKey> Map<String, V> prepareKeysMap(V[] arr) {
        Map<String, V> map = new HashMap<>();
        Stream.of(arr)
                .forEach(v -> map.put(v.getKey(), v));

        return map;
    }

    public interface StringKey {
        String getKey();
    }
}
