package ru.yandex.qe.dispenser.api.util;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import org.jetbrains.annotations.NotNull;

public abstract class JsonDeserializerBase<T> extends JsonDeserializer<T> {
    @NotNull
    @Override
    public abstract T deserialize(@NotNull final JsonParser jp, @NotNull final DeserializationContext dc) throws IOException;

    @NotNull
    protected JsonNode toJson(@NotNull final JsonParser jp) throws IOException {
        return jp.getCodec().readValue(jp, JsonNode.class);
    }
}
