package ru.yandex.qe.dispenser.api.util;

import org.jetbrains.annotations.NotNull;

public enum TextUtils {
    ;

    private static final String UPPERCASE_REGEX = "[0-9A-Z_\\.-]+";

    public static boolean isBlank(@NotNull final String s) {
        return s.trim().isEmpty();
    }

    @NotNull
    public static String requireUpperCase(@NotNull final String s, @NotNull final String message) {
        if (!s.matches(UPPERCASE_REGEX)) {
            throw new IllegalArgumentException(message);
        }
        return s;
    }
}
