package ru.yandex.qe.dispenser.api.util;

import java.util.Collection;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationUtils {

    private ValidationUtils() {
    }

    @NotNull
    public static <T> T requireNonNull(@Nullable final T t, @NotNull final String message) {
        if (t == null) {
            throw new IllegalArgumentException(message);
        }
        return t;
    }

    @NotNull
    public static <T> T requiredFieldValue(@Nullable final T value, final String fieldName) {
        return requireNonNull(value, fieldName + " is required field");
    }

    @NotNull
    public static <T> void requireNotEmpty(@NotNull final Collection<T> collection, final String fieldName) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(fieldName + " should be not empty");
        }
    }

}
