package ru.yandex.qe.dispenser.api.v1;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiBotCampaignGroup {
    private final long id;
    @NotNull
    private final String key;
    @NotNull
    private final String name;
    private final boolean active;
    @NotNull
    private final List<Long> bigOrders;
    @NotNull
    private final String botPreOrderIssueKey;
    @Nullable
    @Deprecated
    private final DiCampaignLight activeCampaign;
    @NotNull
    private final List<DiCampaignLight> activeCampaigns;
    @NotNull
    private final List<DiCampaignLight> campaigns;

    @JsonCreator
    public DiBotCampaignGroup(@NotNull @JsonProperty("id") final Long id,
                              @NotNull @JsonProperty("key") final String key,
                              @NotNull @JsonProperty("name") final String name,
                              @NotNull @JsonProperty("active") final Boolean active,
                              @NotNull @JsonProperty("bigOrders") final List<Long> bigOrders,
                              @NotNull @JsonProperty("botPreOrderIssueKey") final String botPreOrderIssueKey,
                              @Nullable @JsonProperty("activeCampaign") final DiCampaignLight activeCampaign,
                              @NotNull @JsonProperty("activeCampaigns") final List<DiCampaignLight> activeCampaigns,
                              @NotNull @JsonProperty("campaigns") final List<DiCampaignLight> campaigns) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.active = active;
        this.bigOrders = bigOrders;
        this.botPreOrderIssueKey = botPreOrderIssueKey;
        this.activeCampaign = activeCampaign;
        this.activeCampaigns = activeCampaigns;
        this.campaigns = campaigns;
    }

    public long getId() {
        return id;
    }

    @NotNull
    public String getKey() {
        return key;
    }

    @NotNull
    public String getName() {
        return name;
    }

    public boolean isActive() {
        return active;
    }

    @NotNull
    public List<Long> getBigOrders() {
        return bigOrders;
    }

    @NotNull
    public String getBotPreOrderIssueKey() {
        return botPreOrderIssueKey;
    }

    @Nullable
    @Deprecated
    public DiCampaignLight getActiveCampaign() {
        return activeCampaign;
    }

    @NotNull
    public List<DiCampaignLight> getActiveCampaigns() {
        return activeCampaigns;
    }

    @NotNull
    public List<DiCampaignLight> getCampaigns() {
        return campaigns;
    }
}
