package ru.yandex.qe.dispenser.api.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.api.DtoBuilder;
import ru.yandex.qe.dispenser.api.util.ValidationUtils;

import java.util.Objects;

public class DiBotConfigurationReserve {
    @Nullable
    private final Long id;
    @NotNull
    private final String serviceKey;
    @NotNull
    private final Long campaignId;
    @NotNull
    private final Long bigOrderId;
    @NotNull
    private final String locationSegmentKey;
    @NotNull
    private final Long configurationId;
    @NotNull
    private final Long quantity;
    @Nullable
    private final Long storageId;
    @Nullable
    private final Long storageQuantity;

    @JsonCreator
    public DiBotConfigurationReserve(@Nullable @JsonProperty("id") final Long id,
                                     @NotNull @JsonProperty("serviceKey") final String serviceKey,
                                     @NotNull @JsonProperty("campaignId") final Long campaignId,
                                     @NotNull @JsonProperty("bigOrderId") final Long bigOrderId,
                                     @NotNull @JsonProperty("configurationId") final Long configurationId,
                                     @NotNull @JsonProperty("locationSegmentKey") final String locationSegmentKey,
                                     @NotNull @JsonProperty("quantity") final Long quantity,
                                     @Nullable @JsonProperty("storageId") final Long storageId,
                                     @Nullable @JsonProperty("storageQuantity") final Long storageQuantity) {
        this.id = id;
        this.serviceKey = serviceKey;
        this.campaignId = campaignId;
        this.bigOrderId = bigOrderId;
        this.configurationId = configurationId;
        this.locationSegmentKey = locationSegmentKey;
        this.quantity = quantity;
        this.storageId = storageId;
        this.storageQuantity = storageQuantity;
    }

    public DiBotConfigurationReserve(@NotNull final Builder builder) {
        this.serviceKey = ValidationUtils.requireNonNull(builder.serviceKey, "Service key is required!");
        this.campaignId = ValidationUtils.requireNonNull(builder.campaignId, "Campaign id is required!");
        this.bigOrderId = ValidationUtils.requireNonNull(builder.bigOrderId, "Big order id is required!");
        this.locationSegmentKey = ValidationUtils.requireNonNull(builder.locationSegmentKey, "Location key is required");
        this.configurationId = ValidationUtils.requireNonNull(builder.configurationId, "Configuration id is required!");
        this.quantity = ValidationUtils.requireNonNull(builder.quantity, "Quantity is required!");
        this.storageId = builder.storageId;
        this.storageQuantity = builder.storageQuantity;
        this.id = builder.id;
    }

    @Nullable
    public Long getId() {
        return id;
    }

    @NotNull
    public String getServiceKey() {
        return serviceKey;
    }

    @NotNull
    public Long getCampaignId() {
        return campaignId;
    }

    @NotNull
    public Long getBigOrderId() {
        return bigOrderId;
    }

    @NotNull
    public String getLocationSegmentKey() {
        return locationSegmentKey;
    }

    @NotNull
    public Long getConfigurationId() {
        return configurationId;
    }

    @NotNull
    public Long getQuantity() {
        return quantity;
    }

    @Nullable
    public Long getStorageId() {
        return storageId;
    }

    @Nullable
    public Long getStorageQuantity() {
        return storageQuantity;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final DiBotConfigurationReserve that = (DiBotConfigurationReserve) o;
        return Objects.equals(id, that.id) &&
                serviceKey.equals(that.serviceKey) &&
                campaignId.equals(that.campaignId) &&
                bigOrderId.equals(that.bigOrderId) &&
                locationSegmentKey.equals(that.locationSegmentKey) &&
                configurationId.equals(that.configurationId) &&
                quantity.equals(that.quantity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, serviceKey, campaignId, bigOrderId, locationSegmentKey, configurationId, quantity);
    }

    public static final class Builder implements DtoBuilder<DiBotConfigurationReserve> {
        private Long id;
        private String serviceKey;
        private Long campaignId;
        private Long bigOrderId;
        private String locationSegmentKey;
        private Long configurationId;
        private Long quantity;
        private Long storageId;
        private Long storageQuantity;

        public Builder id(final Long id) {
            this.id = id;
            return this;
        }

        public Builder serviceKey(final String serviceKey) {
            this.serviceKey = serviceKey;
            return this;
        }

        public Builder campaignId(final Long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder bigOrderId(final Long bigOrderId) {
            this.bigOrderId = bigOrderId;
            return this;
        }

        public Builder locationSegmentKey(final String locationSegmentKey) {
            this.locationSegmentKey = locationSegmentKey;
            return this;
        }

        public Builder configurationId(final Long configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public Builder quantity(final Long quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder storageId(final Long storageId) {
            this.storageId = storageId;
            return this;
        }

        public Builder storageQuantity(final Long storageQuantity) {
            this.storageQuantity = storageQuantity;
            return this;
        }

        @NotNull
        @Override
        public DiBotConfigurationReserve build() {
            return new DiBotConfigurationReserve(this);
        }
    }
}
