package ru.yandex.qe.dispenser.api.v1;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

public class DiCampaign {
    @NotNull
    private final Long id;
    @NotNull
    private final String key;
    @NotNull
    private final String name;
    @NotNull
    private final String status;
    @NotNull
    private final LocalDate startDate;
    @NotNull
    private final List<BigOrder> campaignBigOrders;
    private final boolean requestCreationDisabled;
    @Deprecated
    private final boolean requestModificationDisabledForNonManagers;
    private final boolean allowedRequestModificationWhenClosed;
    private final boolean allowedModificationOnMissingAdditionalFields;
    @Deprecated
    private final boolean forcedAllowingRequestStatusChange;
    private final boolean singleProviderRequestModeEnabled;
    @Deprecated
    private final boolean allowedRequestCreationForProviderAdmin;
    @Deprecated
    private final boolean allowedRequestCreationForCapacityPlanner;
    @NotNull
    private final String type;
    private final boolean requestModificationDisabled;

    @JsonCreator
    public DiCampaign(@NotNull @JsonProperty("id") final Long id,
                      @NotNull @JsonProperty("key") final String key,
                      @NotNull @JsonProperty("name") final String name,
                      @NotNull @JsonProperty("status") final String status,
                      @NotNull @JsonProperty("startDate") final LocalDate startDate,
                      @NotNull @JsonProperty("campaignBigOrders") final List<BigOrder> campaignBigOrders,
                      @JsonProperty("requestCreationDisabled") final boolean requestCreationDisabled,
                      @Deprecated @JsonProperty("requestModificationDisabledForNonManagers") final boolean requestModificationDisabledForNonManagers,
                      @JsonProperty("allowedRequestModificationWhenClosed") final boolean allowedRequestModificationWhenClosed,
                      @JsonProperty("allowedModificationOnMissingAdditionalFields") final boolean allowedModificationOnMissingAdditionalFields,
                      @Deprecated @JsonProperty("forcedAllowingRequestStatusChange") final boolean forcedAllowingRequestStatusChange,
                      @JsonProperty("singleProviderRequestModeEnabled") final boolean singleProviderRequestModeEnabled,
                      @Deprecated @JsonProperty("allowedRequestCreationForProviderAdmin") final boolean allowedRequestCreationForProviderAdmin,
                      @Deprecated @JsonProperty("allowedRequestCreationForCapacityPlanner") final boolean allowedRequestCreationForCapacityPlanner,
                      @NotNull @JsonProperty("type") final String type,
                      @JsonProperty("requestModificationDisabled") boolean requestModificationDisabled) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.status = status;
        this.startDate = startDate;
        this.campaignBigOrders = campaignBigOrders;
        this.requestCreationDisabled = requestCreationDisabled;
        this.requestModificationDisabledForNonManagers = requestModificationDisabledForNonManagers;
        this.allowedRequestModificationWhenClosed = allowedRequestModificationWhenClosed;
        this.allowedModificationOnMissingAdditionalFields = allowedModificationOnMissingAdditionalFields;
        this.forcedAllowingRequestStatusChange = forcedAllowingRequestStatusChange;
        this.singleProviderRequestModeEnabled = singleProviderRequestModeEnabled;
        this.allowedRequestCreationForProviderAdmin = allowedRequestCreationForProviderAdmin;
        this.allowedRequestCreationForCapacityPlanner = allowedRequestCreationForCapacityPlanner;
        this.type = type;
        this.requestModificationDisabled = requestModificationDisabled;
    }

    @NotNull
    public String getName() {
        return name;
    }

    @NotNull
    public List<BigOrder> getCampaignBigOrders() {
        return campaignBigOrders;
    }

    @NotNull
    public String getStatus() {
        return status;
    }

    @NotNull
    public LocalDate getStartDate() {
        return startDate;
    }

    @NotNull
    public Long getId() {
        return id;
    }

    @NotNull
    public String getKey() {
        return key;
    }

    public boolean isRequestCreationDisabled() {
        return requestCreationDisabled;
    }

    @Deprecated
    public boolean isRequestModificationDisabledForNonManagers() {
        return requestModificationDisabledForNonManagers;
    }

    public boolean isAllowedRequestModificationWhenClosed() {
        return allowedRequestModificationWhenClosed;
    }

    public boolean isAllowedModificationOnMissingAdditionalFields() {
        return allowedModificationOnMissingAdditionalFields;
    }

    @Deprecated
    public boolean isForcedAllowingRequestStatusChange() {
        return forcedAllowingRequestStatusChange;
    }

    public boolean isSingleProviderRequestModeEnabled() {
        return singleProviderRequestModeEnabled;
    }

    @Deprecated
    public boolean isAllowedRequestCreationForProviderAdmin() {
        return allowedRequestCreationForProviderAdmin;
    }

    @Deprecated
    public boolean isAllowedRequestCreationForCapacityPlanner() {
        return allowedRequestCreationForCapacityPlanner;
    }

    @NotNull
    public String getType() {
        return type;
    }

    public boolean isRequestModificationDisabled() {
        return requestModificationDisabled;
    }

    public static class BigOrder {
        @NotNull
        private final Long id;
        @NotNull
        private final LocalDate bigOrderDate;
        @NotNull
        private final Long bigOrderId;

        @JsonCreator
        public BigOrder(@NotNull @JsonProperty("id") final Long id,
                        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
                        @NotNull @JsonProperty("bigOrderDate") final LocalDate bigOrderDate,
                        @NotNull @JsonProperty("bigOrderId") final Long bigOrderId) {
            this.id = id;
            this.bigOrderDate = bigOrderDate;
            this.bigOrderId = bigOrderId;
        }

        @NotNull
        public Long getId() {
            return id;
        }

        @NotNull
        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
        public LocalDate getBigOrderDate() {
            return bigOrderDate;
        }

        @NotNull
        public Long getBigOrderId() {
            return bigOrderId;
        }
    }
}
