package ru.yandex.qe.dispenser.api.v1;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

public class DiCampaignLight {
    private final long id;
    @NotNull
    private final String key;
    @NotNull
    private final String name;
    @NotNull
    private final String status;
    @NotNull
    private final List<Long> bigOrders;
    @NotNull
    private final String type;

    @JsonCreator
    public DiCampaignLight(@NotNull @JsonProperty("id") final Long id,
                           @NotNull @JsonProperty("key") final String key,
                           @NotNull @JsonProperty("name") final String name,
                           @NotNull @JsonProperty("status") final String status,
                           @NotNull @JsonProperty("bigOrders") final List<Long> bigOrders,
                           @NotNull @JsonProperty("type") final String type) {
        this.id = id;
        this.key = key;
        this.name = name;
        this.status = status;
        this.bigOrders = bigOrders;
        this.type = type;
    }

    public long getId() {
        return id;
    }

    @NotNull
    public String getKey() {
        return key;
    }

    @NotNull
    public String getName() {
        return name;
    }

    @NotNull
    public String getStatus() {
        return status;
    }

    @NotNull
    public List<Long> getBigOrders() {
        return bigOrders;
    }

    @NotNull
    public String getType() {
        return type;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final DiCampaignLight that = (DiCampaignLight) o;
        return getId() == that.getId()
                && Objects.equals(getKey(), that.getKey())
                && Objects.equals(getName(), that.getName())
                && Objects.equals(getStatus(), that.getStatus())
                && Objects.equals(getBigOrders(), that.getBigOrders())
                && Objects.equals(getType(), that.getType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getKey(), getName(), getStatus(), getBigOrders(), getType());
    }

    @Override
    public String toString() {
        return "DiCampaignLight{" +
                "id=" + id +
                ", key='" + key + '\'' +
                ", name='" + name + '\'' +
                ", status='" + status + '\'' +
                ", bigOrders=" + bigOrders +
                ", type='" + type + '\'' +
                '}';
    }
}
