package ru.yandex.qe.dispenser.api.v1;

import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.util.SerializationUtils;

public class DiCheckValue<T> {

    @NotNull
    private final DiCheckValueType type;
    @NotNull
    private final T value;

    @JsonCreator
    private static DiCheckValue<?> formJson(@JsonProperty("type") final DiCheckValueType type,
                                            @JsonProperty("value") final Object value) {
        switch (type) {
            case ABSOLUTE:
                final Map<?, ?> rawValue = (Map<?, ?>) value;
                final Object rawDiAmountValue = rawValue.get("value");
                if (rawDiAmountValue instanceof Number) {
                    final double amount = ((Number) rawDiAmountValue).doubleValue();
                    if (amount % 1 != 0) {
                        throw new IllegalArgumentException("Absolute value should be integer");
                    }
                }
                final DiAmount diAmount = SerializationUtils.convertValue(value, DiAmount.class);
                return absolute(diAmount);
            case PERCENT:
                return percent(((Number) value).doubleValue());
        }
        throw new IllegalArgumentException("Invalid check value");
    }

    public DiCheckValue(@NotNull final DiCheckValueType type, @NotNull final T value) {
        this.type = type;
        this.value = value;
    }

    @NotNull
    public DiCheckValueType getType() {
        return type;
    }

    @NotNull
    public T getValue() {
        return value;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final DiCheckValue<?> that = (DiCheckValue<?>) o;
        return type == that.type &&
                Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, value);
    }

    @NotNull
    public static DiCheckValue<DiAmount> absolute(@NotNull final DiAmount amount) {
        return new DiCheckValue<>(DiCheckValueType.ABSOLUTE, amount);
    }

    @NotNull
    public static DiCheckValue<Double> percent(@NotNull final Double amount) {
        return new DiCheckValue<>(DiCheckValueType.PERCENT, amount);
    }
}
