package ru.yandex.qe.dispenser.api.v1;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DiGoal {
    private final long id;
    @NotNull
    private final String name;

    @JsonCreator
    public DiGoal(@JsonProperty("id") final long id,
                  @JsonProperty("name") final String name) {
        this.id = id;
        this.name = name;
    }

    public long getId() {
        return id;
    }

    @NotNull
    public String getName() {
        return name;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final DiGoal diGoal = (DiGoal) o;
        return id == diGoal.id &&
                name.equals(diGoal.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name);
    }
}
