package ru.yandex.qe.dispenser.api.v1;

import java.time.Instant;

import ru.yandex.qe.dispenser.api.DtoBuilder;

public abstract class DiHistoryEvent {
    private final long id;
    private final Long tvmId;
    private final String person;
    private final Instant updated;
    private final String comment;

    protected DiHistoryEvent(final long id, final Long tvmId, final String person, final Instant updated, final String comment) {
        this.id = id;
        this.tvmId = tvmId;
        this.person = person;
        this.updated = updated;
        this.comment = comment;
    }

    public String getComment() {
        return comment;
    }

    public Long getTvmId() {
        return tvmId;
    }

    public String getPerson() {
        return person;
    }

    public String getUpdated() {
        return updated.toString();
    }

    public long getId() {
        return id;
    }

    public static abstract class Builder<T, B extends Builder<T, B>> implements DtoBuilder<T> {
        protected long id;
        protected Long tvmId;
        protected String person;
        protected Instant updated;
        protected String comment;

        protected abstract B self();

        public B id(final long id) {
            this.id = id;
            return self();
        }

        public B comment(final String comment) {
            this.comment = comment;
            return self();
        }

        public B tvmId(final Long tvmId) {
            this.tvmId = tvmId;
            return self();
        }

        public B person(final String person) {
            this.person = person;
            return self();
        }

        public B updated(final Instant updated) {
            this.updated = updated;
            return self();
        }
    }
}
