package ru.yandex.qe.dispenser.api.v1;

import java.util.Comparator;
import java.util.function.Function;

import org.jetbrains.annotations.NotNull;

public enum DiOrder {
    ASC {
        @Override
        @NotNull
        public <T, U extends Comparable<U>> Comparator<T> comparing(@NotNull final Function<T, U> keyExtractor) {
            return Comparator.comparing(keyExtractor);
        }
    },
    DESC {
        @Override
        @NotNull
        public <T, U extends Comparable<U>> Comparator<T> comparing(@NotNull final Function<T, U> keyExtractor) {
            return Comparator.comparing(keyExtractor).reversed();
        }
    };

    @NotNull
    public abstract <T, U extends Comparable<U>> Comparator<T> comparing(@NotNull Function<T, U> keyExtractor);
}
