package ru.yandex.qe.dispenser.api.v1;


import com.fasterxml.jackson.annotation.JsonProperty;

public class DiProperty {
    private final String entityKey;
    private final String propertyKey;
    private final Type type;
    private final Object value;

    public DiProperty(@JsonProperty("entityKey") final String entityKey,
                      @JsonProperty("propertyKey") final String propertyKey,
                      @JsonProperty("type") final Type type,
                      @JsonProperty("value") final Object value) {
        this.entityKey = entityKey;
        this.propertyKey = propertyKey;
        this.type = type;
        this.value = value;
    }

    public String getEntityKey() {
        return entityKey;
    }

    public String getPropertyKey() {
        return propertyKey;
    }

    public Type getType() {
        return type;
    }

    public Object getValue() {
        return value;
    }

    public static class Builder {
        private String entityKey;
        private String propertyKey;
        private Type type;
        private Object value;

        public Builder entityKey(final String entityKey) {
            this.entityKey = entityKey;
            return this;
        }

        public Builder propertyKey(final String propertyKey) {
            this.propertyKey = propertyKey;
            return this;
        }

        public Builder type(final Type type) {
            this.type = type;
            return this;
        }

        public Builder value(final Object value) {
            this.value = value;
            return this;
        }

        public DiProperty build() {
            return new DiProperty(entityKey, propertyKey, type, value);
        }

    }

    public static class Body {
        private final String entityKey;
        private final String propertyKey;
        private final Object value;

        public Body(@JsonProperty("entityKey") final String entityKey,
                    @JsonProperty("propertyKey") final String propertyKey,
                    @JsonProperty("value") final Object value) {
            this.entityKey = entityKey;
            this.propertyKey = propertyKey;
            this.value = value;
        }

        public String getEntityKey() {
            return entityKey;
        }

        public String getPropertyKey() {
            return propertyKey;
        }

        public Object getValue() {
            return value;
        }
    }

    public enum Type {
        BOOLEAN,
        STRING
    }
}
