package ru.yandex.qe.dispenser.api.v1;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiQuotaChangeStatistic {

    @NotNull
    private final List<Group> items;

    public DiQuotaChangeStatistic(@NotNull @JsonProperty("items") final List<Group> items) {
        this.items = items;
    }

    @NotNull
    public List<Group> getItems() {
        return items;
    }

    public static class Resource {
        @NotNull
        private final ResourceKey key;
        @NotNull
        private final String name;
        @NotNull
        private final DiAmount amount;
        private final long cost;
        @Nullable
        private final String owningCost;

        @JsonCreator
        public Resource(@NotNull @JsonProperty("key") final ResourceKey key,
                        @NotNull @JsonProperty("name") final String name,
                        @NotNull @JsonProperty("amount") final DiAmount amount,
                        @JsonProperty("cost") final long cost,
                        @Nullable @JsonProperty("owning_cost") String owningCost) {
            this.key = key;
            this.name = name;
            this.amount = amount;
            this.cost = cost;
            this.owningCost = owningCost;
        }

        @NotNull
        public ResourceKey getKey() {
            return key;
        }

        @NotNull
        public String getName() {
            return name;
        }

        @NotNull
        public DiAmount getAmount() {
            return amount;
        }

        public long getCost() {
            return cost;
        }

        @Nullable
        @JsonProperty("owning_cost")
        public String getOwningCost() {
            return owningCost;
        }

        public static class ResourceKey {
            private final String resourceKey;
            private final String serviceKey;

            public ResourceKey(@NotNull @JsonProperty("resourceKey") final String resourceKey,
                               @NotNull @JsonProperty("serviceKey") final String serviceKey) {
                this.resourceKey = resourceKey;
                this.serviceKey = serviceKey;
            }

            public String getResourceKey() {
                return resourceKey;
            }

            public String getServiceKey() {
                return serviceKey;
            }

            @Override
            public boolean equals(final Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || getClass() != o.getClass()) {
                    return false;
                }
                final ResourceKey that = (ResourceKey) o;
                return resourceKey.equals(that.resourceKey) &&
                        serviceKey.equals(that.serviceKey);
            }

            @Override
            public int hashCode() {
                return Objects.hash(resourceKey, serviceKey);
            }
        }
    }

    public static class CountWithUnit {
        private final Long count;
        private final String unit;

        public CountWithUnit(@JsonProperty("count") final Long count,
                             @JsonProperty("unit") final String unit) {
            this.count = count;
            this.unit = unit;
        }

        public Long getCount() {
            return count;
        }

        public String getUnit() {
            return unit;
        }
    }

    public static class Group {
        @NotNull
        private final String title;
        @NotNull
        private final List<Section> items;
        @NotNull
        private final Map<String, String> summary;
        @NotNull
        private final Map<String, CountWithUnit> summaryWithUnits;
        @Nullable
        private final String totalOwningCost;
        @Nullable
        private final Map<String, String> summaryOwningCosts;
        @NotNull
        private final Map<Long, String> summaryPercentageByCampaignOwningCosts;

        public Group(@NotNull @JsonProperty("title") final String title,
                     @NotNull @JsonProperty("items") final List<Section> items,
                     @NotNull @JsonProperty("summary") final Map<String, String> summary,
                     @NotNull @JsonProperty("summary_with_units") final Map<String, CountWithUnit> summaryWithUnits,
                     @Nullable @JsonProperty("total_owning_cost") final String totalOwningCost,
                     @Nullable @JsonProperty("summary_owning_costs") Map<String, String> summaryOwningCosts,
                     @NotNull @JsonProperty("summary_percentage_by_campaign_owning_costs") Map<Long, String> summaryPercentageByCampaignOwningCosts) {
            this.title = title;
            this.items = items;
            this.summary = summary;
            this.summaryWithUnits = summaryWithUnits;
            this.totalOwningCost = totalOwningCost;
            this.summaryOwningCosts = summaryOwningCosts;
            this.summaryPercentageByCampaignOwningCosts = summaryPercentageByCampaignOwningCosts;
        }

        @NotNull
        public String getTitle() {
            return title;
        }

        @NotNull
        public List<Section> getItems() {
            return items;
        }

        @NotNull
        public Map<String, String> getSummary() {
            return summary;
        }

        @NotNull
        @JsonProperty("summary_with_units")
        public Map<String, CountWithUnit> getSummaryWithUnits() {
            return summaryWithUnits;
        }

        @Nullable
        @JsonProperty("total_owning_cost")
        public String getTotalOwningCost() {
            return totalOwningCost;
        }

        @Nullable
        @JsonProperty("summary_owning_costs")
        public Map<String, String> getSummaryOwningCosts() {
            return summaryOwningCosts;
        }

        @NotNull
        @JsonProperty("summary_percentage_by_campaign_owning_costs")
        public Map<Long, String> getSummaryPercentageByCampaignOwningCosts() {
            return summaryPercentageByCampaignOwningCosts;
        }
    }

    public static class Section {
        @NotNull
        private final String title;
        @NotNull
        private final List<Item> items;

        public Section(@NotNull @JsonProperty("title") final String title,
                       @NotNull @JsonProperty("items") final List<Item> items) {
            this.title = title;
            this.items = items;
        }

        @NotNull
        public String getTitle() {
            return title;
        }

        @NotNull
        public List<Item> getItems() {
            return items;
        }
    }

    public static class Item {
        @NotNull
        private final String title;
        @NotNull
        private final List<Resource> resources;

        public Item(@NotNull @JsonProperty("title") final String title,
                    @NotNull @JsonProperty("resources") final List<Resource> resources) {
            this.title = title;
            this.resources = resources;
        }

        @NotNull
        public String getTitle() {
            return title;
        }

        @NotNull
        public List<Resource> getResources() {
            return resources;
        }
    }

}
