package ru.yandex.qe.dispenser.api.v1;

import java.time.Instant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

public class DiQuotaHistoryEvent extends DiHistoryEvent {

    private final DiQuotaKey quotaKey;
    private final long oldMax;
    private final long newMax;
    private final long oldOwnMax;
    private final long newOwnMax;
    private final String issueKey;

    @JsonCreator
    public DiQuotaHistoryEvent(@JsonProperty("id") final long id,
                               @JsonProperty("tvmId") final Long tvmId,
                               @JsonProperty("person") final String person,
                               @JsonProperty("updated") final Instant updated,
                               @JsonProperty("comment") final String comment,
                               @JsonProperty("quotaKey") final DiQuotaKey quotaKey,
                               @JsonProperty("oldMax") final long oldMax,
                               @JsonProperty("newMax") final long newMax,
                               @JsonProperty("oldOwnMax") final long oldOwnMax,
                               @JsonProperty("newOwnMax") final long newOwnMax,
                               @JsonProperty("issueKey") final String issueKey) {
        super(id, tvmId, person, updated, comment);
        this.quotaKey = quotaKey;
        this.oldMax = oldMax;
        this.newMax = newMax;
        this.oldOwnMax = oldOwnMax;
        this.newOwnMax = newOwnMax;
        this.issueKey = issueKey;
    }

    public DiQuotaKey getQuotaKey() {
        return quotaKey;
    }

    public long getOldMax() {
        return oldMax;
    }

    public long getNewMax() {
        return newMax;
    }

    public long getOldOwnMax() {
        return oldOwnMax;
    }

    public long getNewOwnMax() {
        return newOwnMax;
    }

    public String getIssueKey() {
        return issueKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder extends DiHistoryEvent.Builder<DiQuotaHistoryEvent, Builder> {
        private DiQuotaKey quotaKey;
        private long oldMax;
        private long newMax;
        private long oldOwnMax;
        private long newOwnMax;
        private String issueKey;

        public Builder issueKey(final String issueKey) {
            this.issueKey = issueKey;
            return this;
        }

        public Builder quotaKey(final DiQuotaKey quotaKey) {
            this.quotaKey = quotaKey;
            return this;
        }

        public Builder oldMax(final long oldMax) {
            this.oldMax = oldMax;
            return this;
        }

        public Builder newMax(final long newMax) {
            this.newMax = newMax;
            return this;
        }

        public Builder oldOwnMax(final long oldOwnMax) {
            this.oldOwnMax = oldOwnMax;
            return this;
        }

        public Builder newOwnMax(final long newOwnMax) {
            this.newOwnMax = newOwnMax;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @NotNull
        @Override
        public DiQuotaHistoryEvent build() {
            return new DiQuotaHistoryEvent(id, tvmId, person, updated, comment, quotaKey, oldMax, newMax, oldOwnMax, newOwnMax, issueKey);
        }
    }
}
