package ru.yandex.qe.dispenser.api.v1;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.DtoBuilder;
import ru.yandex.qe.dispenser.api.util.ValidationUtils;

@ParametersAreNonnullByDefault
public class DiQuotaLightView {
    @NotNull
    private final DiQuotaKey key;
    private final long max;
    private final long actual;
    private final long ownMax;
    private final long ownActual;
    @Nullable
    private final Long lastOverquotingTs;

    private DiQuotaLightView(final Builder builder) {
        this.key = ValidationUtils.requireNonNull(builder.key, "key is required");
        this.max = builder.max;
        this.actual = builder.actual;
        this.lastOverquotingTs = builder.lastOverquotingTs;
        this.ownMax = builder.ownMax;
        this.ownActual = builder.ownActual;
    }

    public static Builder withKey(final DiQuotaKey key) {
        return new Builder(key);
    }

    @JsonCreator
    public static DiQuotaLightView fromJson(@JsonProperty("key") final DiQuotaKey key,
                                            @JsonProperty("max") final long max,
                                            @JsonProperty("actual") final long actual,
                                            @JsonProperty("lastOverquotingTs") @Nullable final Long lastOverquotingTs,
                                            @JsonProperty("ownMax") final long ownMax,
                                            @JsonProperty("ownActual") final long ownActual) {
        return withKey(key)
                .withMax(max)
                .withActual(actual)
                .withLastOverquotingTs(lastOverquotingTs)
                .withOwnMax(ownMax)
                .withOwnActual(ownActual)
                .build();
    }

    @NotNull
    public DiQuotaKey getKey() {
        return key;
    }

    public long getMax() {
        return max;
    }

    public long getActual() {
        return actual;
    }

    public long getOwnMax() {
        return ownMax;
    }

    public long getOwnActual() {
        return ownActual;
    }

    @Nullable
    public Long getLastOverquotingTs() {
        return lastOverquotingTs;
    }

    public static class Builder implements DtoBuilder<DiQuotaLightView> {
        @NotNull
        private final DiQuotaKey key;
        private long max;
        private long actual;
        private long ownMax;
        private long ownActual;
        @Nullable
        private Long lastOverquotingTs;

        private Builder(final DiQuotaKey key) {
            this.key = key;
        }

        public Builder withMax(final long max) {
            this.max = max;
            return this;
        }

        public Builder withOwnMax(final long ownMax) {
            this.ownMax = ownMax;
            return this;
        }

        public Builder withActual(final long actual) {
            this.actual = actual;
            return this;
        }

        public Builder withOwnActual(final long ownActual) {
            this.ownActual = ownActual;
            return this;
        }

        public Builder withLastOverquotingTs(@Nullable final Long lastOverquotingTs) {
            this.lastOverquotingTs = lastOverquotingTs;
            return this;
        }

        @NotNull
        @Override
        public DiQuotaLightView build() {
            return new DiQuotaLightView(this);
        }
    }
}
