package ru.yandex.qe.dispenser.api.v1;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.util.ValidationUtils;

public class DiQuotaMaxDeltaUpdate extends DiQuotaMaxUpdateBase {
    private final DiSignedAmount maxDelta;
    private final DiSignedAmount ownMaxDelta;

    @JsonCreator
    public DiQuotaMaxDeltaUpdate(final @NotNull @JsonProperty("resourceKey") String resourceKey,
                                 final @NotNull @JsonProperty("projectKey") String projectKey,
                                 final @Nullable @JsonProperty("quotaSpecKey") String quotaSpecKey,
                                 final @NotNull @JsonProperty("segmentKeys") Set<String> segmentKeys,
                                 final @Nullable @JsonProperty("max") DiSignedAmount maxDelta,
                                 final @Nullable @JsonProperty("ownMax") DiSignedAmount ownMaxDelta) {
        super(resourceKey, projectKey, quotaSpecKey, segmentKeys);
        this.maxDelta = maxDelta;
        this.ownMaxDelta = ownMaxDelta;
    }

    private DiQuotaMaxDeltaUpdate(final Builder builder) {
        this(builder.resourceKey,
                ValidationUtils.requireNonNull(builder.projectKey, "Project Key is required"),
                builder.quotaSpecKey,
                builder.segmentKeys,
                builder.maxDelta,
                builder.ownMaxDelta);
    }

    public DiSignedAmount getMaxDelta() {
        return maxDelta;
    }

    public DiSignedAmount getOwnMaxDelta() {
        return ownMaxDelta;
    }

    public static Builder forResource(@NotNull final String resourceKey) {
        return new Builder(resourceKey);
    }

    public static class Builder extends DiQuotaMaxUpdateBase.BuilderBase<DiQuotaMaxDeltaUpdate, Builder> {
        private DiSignedAmount maxDelta;
        private DiSignedAmount ownMaxDelta;

        private Builder(final @NotNull String resourceKey) {
            super(resourceKey);
        }

        public Builder withMaxDelta(@NotNull final DiSignedAmount maxDelta) {
            this.maxDelta = maxDelta;
            return this;
        }

        public Builder withOwnMaxDelta(@NotNull final DiSignedAmount ownMaxDelta) {
            this.ownMaxDelta = ownMaxDelta;
            return this;
        }

        @NotNull
        @Override
        public DiQuotaMaxDeltaUpdate build() {
            return new DiQuotaMaxDeltaUpdate(this);
        }
    }
}
