package ru.yandex.qe.dispenser.api.v1;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.util.ValidationUtils;

public class DiQuotaMaxUpdate extends DiQuotaMaxUpdateBase {
    @Nullable
    private final DiAmount max;
    @Nullable
    private final DiAmount ownMax;

    @JsonCreator
    public DiQuotaMaxUpdate(@Nullable @JsonProperty("max") final DiAmount max,
                            @Nullable @JsonProperty("ownMax") final DiAmount ownMax,
                            @NotNull @JsonProperty("resourceKey") final String resourceKey,
                            @NotNull @JsonProperty("projectKey") final String projectKey,
                            @Nullable @JsonProperty("quotaSpecKey") final String quotaSpecKey,
                            @NotNull @JsonProperty("segmentKeys") final Set<String> segmentKeys) {
        super(resourceKey, projectKey, quotaSpecKey, segmentKeys);
        this.max = max;
        this.ownMax = ownMax;
    }

    private DiQuotaMaxUpdate(@NotNull final Builder builder) {
        this(builder.max,
                builder.ownMax,
                builder.resourceKey,
                ValidationUtils.requireNonNull(builder.projectKey, "Project Key is required"),
                builder.quotaSpecKey,
                builder.segmentKeys);
    }

    @Nullable
    public DiAmount getMax() {
        return max;
    }

    @Nullable
    public DiAmount getOwnMax() {
        return ownMax;
    }

    public static Builder forResource(@NotNull final String resourceKey) {
        return new Builder(resourceKey);
    }

    public static class Builder extends DiQuotaMaxUpdateBase.BuilderBase<DiQuotaMaxUpdate, Builder> {
        @Nullable
        private DiAmount max;
        @Nullable
        private DiAmount ownMax;

        private Builder(@NotNull final String resourceKey) {
            super(resourceKey);
        }

        public Builder withMax(@NotNull final DiAmount max) {
            this.max = max;
            return this;
        }

        public Builder withOwnMax(@NotNull final DiAmount ownMax) {
            this.ownMax = ownMax;
            return this;
        }

        @NotNull
        @Override
        public DiQuotaMaxUpdate build() {
            return new DiQuotaMaxUpdate(this);
        }
    }
}
