package ru.yandex.qe.dispenser.api.v1;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.DtoBuilder;

public abstract class DiQuotaMaxUpdateBase {
    @NotNull
    private final String resourceKey;
    @NotNull
    private final String projectKey;
    @Nullable
    private final String quotaSpecKey;
    @NotNull
    private final Set<String> segmentKeys;

    protected DiQuotaMaxUpdateBase(@NotNull final String resourceKey,
                                   @NotNull final String projectKey,
                                   @Nullable final String quotaSpecKey,
                                   @NotNull final Set<String> segmentKeys) {
        this.resourceKey = resourceKey;
        this.projectKey = projectKey;
        this.quotaSpecKey = quotaSpecKey;
        this.segmentKeys = segmentKeys;
    }

    @NotNull
    public String getResourceKey() {
        return resourceKey;
    }

    @NotNull
    public String getProjectKey() {
        return projectKey;
    }

    @Nullable
    public String getQuotaSpecKey() {
        return quotaSpecKey;
    }

    @NotNull
    public Set<String> getSegmentKeys() {
        return segmentKeys;
    }

    protected abstract static class BuilderBase<T extends DiQuotaMaxUpdateBase, B extends BuilderBase<T, B>> implements DtoBuilder<T> {
        @NotNull
        protected final String resourceKey;
        @Nullable
        protected String projectKey;
        @Nullable
        protected String quotaSpecKey;
        @NotNull
        protected final Set<String> segmentKeys = new HashSet<>();

        protected BuilderBase(@NotNull final String resourceKey) {
            this.resourceKey = resourceKey;
        }

        public B forProject(@NotNull final String projectKey) {
            this.projectKey = projectKey;
            return self();
        }

        public B withQuotaSpecKey(@NotNull final String quotaSpecKey) {
            this.quotaSpecKey = quotaSpecKey;
            return self();
        }

        public B withSegmentKeys(@NotNull final Collection<String> segmentKeys) {
            this.segmentKeys.addAll(segmentKeys);
            return self();
        }

        public B withSegmentKeys(@NotNull final String... segmentKeys) {
            return withSegmentKeys(Arrays.asList(segmentKeys));
        }

        @SuppressWarnings("unchecked")
        private B self() {
            return (B) this;
        }
    }
}
