package ru.yandex.qe.dispenser.api.v1;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiQuotaMaxUpdateRequest<T extends DiQuotaMaxUpdateBase> {
    @NotNull
    private final List<T> updates;
    @Nullable
    private final String description;
    @Nullable
    private final String ticketKey;

    @JsonCreator
    public DiQuotaMaxUpdateRequest(@NotNull @JsonProperty("updates") final List<T> updates,
                                   @Nullable @JsonProperty("description") final String description,
                                   @Nullable @JsonProperty("ticketKey") final String ticketKey) {
        this.updates = updates;
        this.description = description;
        this.ticketKey = ticketKey;
    }

    @NotNull
    public List<T> getUpdates() {
        return updates;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    @Nullable
    public String getTicketKey() {
        return ticketKey;
    }
}
