package ru.yandex.qe.dispenser.api.v1;

import java.time.Instant;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

public class DiQuotaRequestHistoryEvent extends DiHistoryEvent {
    private final long requestId;
    private final DiQuotaRequestHistoryEventType type;
    private final Map<String, Object> oldData;
    private final Map<String, Object> newData;

    @JsonCreator
    public DiQuotaRequestHistoryEvent(@JsonProperty("id") final long id,
                                      @JsonProperty("tvmId") final Long tvmId,
                                      @JsonProperty("person") final String person,
                                      @JsonProperty("updated") final Instant updated,
                                      @JsonProperty("comment") final String comment,
                                      @JsonProperty("requestId") final long requestId,
                                      @JsonProperty("type") final DiQuotaRequestHistoryEventType type,
                                      @JsonProperty("oldData") final Map<String, Object> oldData,
                                      @JsonProperty("newData") final Map<String, Object> newData) {
        super(id, tvmId, person, updated, comment);
        this.requestId = requestId;
        this.type = type;
        this.oldData = oldData;
        this.newData = newData;
    }

    public DiQuotaRequestHistoryEventType getType() {
        return type;
    }

    public long getRequestId() {
        return requestId;
    }

    public Map<String, Object> getOldData() {
        return oldData;
    }

    public Map<String, Object> getNewData() {
        return newData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder extends DiHistoryEvent.Builder<DiQuotaRequestHistoryEvent, Builder> {
        private long requestId;
        private DiQuotaRequestHistoryEventType type;
        private Map<String, Object> oldData;
        private Map<String, Object> newData;

        public Builder requestId(final long requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder type(final DiQuotaRequestHistoryEventType type) {
            this.type = type;
            return this;
        }

        public Builder oldData(final Map<String, Object> oldData) {
            this.oldData = oldData;
            return this;
        }

        public Builder newData(final Map<String, Object> newData) {
            this.newData = newData;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @NotNull
        @Override
        public DiQuotaRequestHistoryEvent build() {
            return new DiQuotaRequestHistoryEvent(id, tvmId, person, updated, comment, requestId, type, oldData, newData);
        }
    }
}
