package ru.yandex.qe.dispenser.api.v1;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class DiRequestPreOrder {
    private final PreOrder preOrder;
    private final double servers;
    @Nullable
    private final Double cost;

    @JsonCreator
    public DiRequestPreOrder(@JsonProperty("preOrder") final PreOrder preOrder,
                             @JsonProperty("servers") final double servers,
                             @Nullable @JsonProperty("cost") final Double cost) {
        this.preOrder = preOrder;
        this.servers = servers;
        this.cost = cost;
    }

    public PreOrder getPreOrder() {
        return preOrder;
    }

    public double getServers() {
        return servers;
    }

    @Nullable
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Double getCost() {
        return cost;
    }

    public static class PreOrder {
        private final long id;
        private final String name;
        private final String configurationName;
        private final long count;
        private final DiQuotaChangeRequest.Service service;

        @JsonCreator
        public PreOrder(@JsonProperty("id") final long id,
                        @JsonProperty("name") final String name,
                        @JsonProperty("configurationName") final String configurationName,
                        @JsonProperty("count") final long count,
                        @JsonProperty("service") final DiQuotaChangeRequest.Service service) {
            this.id = id;
            this.name = name;
            this.configurationName = configurationName;
            this.count = count;
            this.service = service;
        }

        public long getId() {
            return id;
        }

        public String getName() {
            return name;
        }

        public String getConfigurationName() {
            return configurationName;
        }

        public long getCount() {
            return count;
        }

        public DiQuotaChangeRequest.Service getService() {
            return service;
        }
    }
}
