package ru.yandex.qe.dispenser.api.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.KeyBase;
import ru.yandex.qe.dispenser.api.util.ValidationUtils;

public class DiResourceGroup extends KeyBase<String> {
    @NotNull
    private final DiService service;
    @NotNull
    private final String name;
    @Nullable
    private final Integer priority;

    private DiResourceGroup(@NotNull final Builder builder) {
        super(builder.key);
        service = ValidationUtils.requireNonNull(builder.service, "Service is required");
        name = ValidationUtils.requireNonNull(builder.name, "Name is required");
        priority = builder.priority;
    }

    public static Builder withKey(@NotNull final String key) {
        return new Builder(key);
    }

    @JsonCreator
    private static DiResourceGroup createResourceGroup(@JsonProperty("key") final String key,
                                                       @JsonProperty("service") final DiService service,
                                                       @JsonProperty("name") final String name) {
        return withKey(ValidationUtils.requireNonNull(key, "Key is required"))
                .inService(ValidationUtils.requireNonNull(service, "Service is required"))
                .withName(name)
                .build();
    }

    @NotNull
    public DiService getService() {
        return service;
    }

    @NotNull
    public String getName() {
        return name;
    }

    @Nullable
    public Integer getPriority() {
        return priority;
    }

    public static class Builder {
        @NotNull
        private final String key;
        @Nullable
        private DiService service;
        @Nullable
        private String name;
        @Nullable
        private Integer priority;

        private Builder(@NotNull final String key) {
            this.key = key;
        }

        public Builder inService(@NotNull final DiService service) {
            this.service = service;
            return this;
        }

        public Builder withName(@NotNull final String name) {
            this.name = name;
            return this;
        }

        @NotNull
        public Builder withPriority(@Nullable final Integer priority) {
            this.priority = priority;
            return this;
        }

        public DiResourceGroup build() {
            return new DiResourceGroup(this);
        }
    }
}
