package ru.yandex.qe.dispenser.api.v1;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class DiResourcePreOrderRequest {
    private final DiQuotaChangeRequest request;
    private final List<ProviderServersCost> providerServersCosts;

    @JsonCreator
    public DiResourcePreOrderRequest(@JsonProperty("request") final DiQuotaChangeRequest request,
                                     @JsonProperty("providerServersCosts") final List<ProviderServersCost> providerServersCosts) {
        this.request = request;
        this.providerServersCosts = providerServersCosts;
    }

    public DiQuotaChangeRequest getRequest() {
        return request;
    }

    public List<ProviderServersCost> getProviderServersCosts() {
        return providerServersCosts;
    }

    public static class ProviderServersCost {
        private final String serviceKey;
        private final Double serversCost;

        @JsonCreator
        public ProviderServersCost(@JsonProperty("serviceKey") final String serviceKey,
                                   @JsonProperty("serversCost") final Double serversCost) {
            this.serviceKey = serviceKey;
            this.serversCost = serversCost;
        }

        public String getServiceKey() {
            return serviceKey;
        }

        public Double getServersCost() {
            return serversCost;
        }
    }
}
