package ru.yandex.qe.dispenser.api.v1;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.DtoBuilder;

public class DiResourceSegmentation {
    @NotNull
    private final DiResource resource;
    @NotNull
    private final DiSegmentation segmentation;

    private DiResourceSegmentation(@NotNull final Builder builder) {
        resource = builder.resource;
        segmentation = builder.segmentation;
    }

    @NotNull
    public DiResource getResource() {
        return resource;
    }

    @NotNull
    public DiSegmentation getSegmentation() {
        return segmentation;
    }

    public static class Builder implements DtoBuilder<DiResourceSegmentation> {
        @NotNull
        private final DiResource resource;
        @NotNull
        private final DiSegmentation segmentation;

        private Builder(@NotNull final DiResource resource, @NotNull final DiSegmentation segmentation) {
            this.resource = resource;
            this.segmentation = segmentation;
        }

        @NotNull
        @Override
        public DiResourceSegmentation build() {
            return new DiResourceSegmentation(this);
        }
    }
}
