package ru.yandex.qe.dispenser.api.v1;

import org.jetbrains.annotations.NotNull;

/**
 * ATTENTION: changes in this enum can break clients!
 */
public enum DiResourceType {
    ENUMERABLE(DiUnit.PERMILLE),
    MEMORY(DiUnit.BYTE),
    @Deprecated
    MONEY(DiUnit.CURRENCY),
    @Deprecated
    POWER(DiUnit.PERCENT),
    STORAGE(DiUnit.BYTE),
    TRAFFIC(DiUnit.BPS),
    BINARY_TRAFFIC(DiUnit.BINARY_BPS),
    PROCESSOR(DiUnit.PERMILLE_CORES),
    MESSAGE_TRAFFIC(DiUnit.MPS),
    RUBLE_BUDGET(DiUnit.RUBLES),
    STORAGE_BASE(DiUnit.GIBIBYTE_BASE),
    MEMORY_BASE(DiUnit.GIBIBYTE_BASE);

    @NotNull
    private final DiUnit baseUnit;

    DiResourceType(@NotNull final DiUnit baseUnit) {
        this.baseUnit = baseUnit;
    }

    @NotNull
    public DiUnit getBaseUnit() {
        return baseUnit;
    }
}
