package ru.yandex.qe.dispenser.api.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.DtoBuilder;
import ru.yandex.qe.dispenser.api.KeyBase;

public class DiSegment extends KeyBase<String> {
    private final DiSegmentation segmentation;
    private final String name;
    private final String description;
    private final Short priority;

    @JsonCreator
    private static DiSegment createSegment(@JsonProperty("key") final String key,
                                           @JsonProperty("segmentation") final DiSegmentation segmentation,
                                           @JsonProperty("name") final String name,
                                           @JsonProperty("description") final String description,
                                           @JsonProperty("priority") final Short priority) {
        return new Builder(key)
                .inSegmentation(segmentation)
                .withName(name)
                .withDescription(description)
                .withPriority(priority)
                .build();
    }

    private DiSegment(@NotNull final Builder builder) {
        super(builder.getKey());
        name = builder.name;
        description = builder.description;
        segmentation = builder.segmentation;
        priority = builder.priority;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public Short getPriority() {
        return priority;
    }

    public DiSegmentation getSegmentation() {
        return segmentation;
    }

    public static class Builder extends KeyBase.Builder<String, Builder> implements DtoBuilder<DiSegment> {
        protected String name;
        protected String description;
        protected Short priority;
        protected DiSegmentation segmentation;

        public Builder(@NotNull final String key) {
            super(key);
        }

        public Builder inSegmentation(@NotNull final DiSegmentation segmentation) {
            this.segmentation = segmentation;
            return this;
        }

        public Builder withName(@NotNull final String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(@NotNull final String description) {
            this.description = description;
            return this;
        }

        public Builder withPriority(@NotNull final Short priority) {
            this.priority = priority;
            return this;
        }

        @NotNull
        @Override
        public DiSegment build() {
            return new DiSegment(this);
        }
    }
}
