package ru.yandex.qe.dispenser.api.v1;

import java.util.Collection;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.qe.dispenser.api.util.SerializationUtils;

public class DiSetAmountResult {

    public static final DiSetAmountResult SUCCESS = new DiSetAmountResult("SUCCESS");

    private final String status;

    public static Errors.Item error(final String message, final Collection<Long> problemRequestIds, final Collection<String> problemRequestTicketKeys) {
        return new Errors.Item(message, problemRequestIds, problemRequestTicketKeys);
    }

    @JsonCreator
    private static DiSetAmountResult formJson(final Map<String, Object> data) {
        switch ((String) data.get("status")) {
            case "SUCCESS":
                return SUCCESS;
            case "ERROR":
                return SerializationUtils.convertValue(data, Errors.class);
            default:
                throw new IllegalArgumentException("Invalid result json");
        }
    }

    protected DiSetAmountResult(final String status) {
        this.status = status;
    }

    public String getStatus() {
        return status;
    }

    @Override
    public String toString() {
        return "DiSetAmountResult{" +
                "status='" + status + '\'' +
                '}';
    }

    public static class Errors extends DiSetAmountResult {
        private final Collection<Item> errorItems;

        @JsonCreator
        public Errors(@JsonProperty("errors") final Collection<Item> errorItems) {
            super("ERROR");
            this.errorItems = errorItems;
        }

        public Collection<Item> getErrors() {
            return errorItems;
        }

        public static class Item {
            private final String message;
            private final Collection<Long> problemRequestIds;
            private final Collection<String> problemTicketKeys;

            @JsonCreator
            public Item(@JsonProperty("message") final String message,
                        @JsonProperty("problemRequestIds") final Collection<Long> problemRequestIds,
                        @JsonProperty("problemTicketKeys") final Collection<String> problemTicketKeys) {
                this.message = message;
                this.problemRequestIds = problemRequestIds;
                this.problemTicketKeys = problemTicketKeys;
            }

            public String getMessage() {
                return message;
            }

            public Collection<Long> getProblemRequestIds() {
                return problemRequestIds;
            }

            public Collection<String> getProblemTicketKeys() {
                return problemTicketKeys;
            }

            @Override
            public String toString() {
                return "Item{" +
                        "message='" + message + '\'' +
                        ", problemRequestIds=" + problemRequestIds +
                        ", problemTicketKeys=" + problemTicketKeys +
                        '}';
            }
        }

        @Override
        public String toString() {
            return "DiSetAmountResult.Errors{" +
                    "errorItems=" + errorItems +
                    '}';
        }
    }
}
