package ru.yandex.qe.dispenser.api.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

public class DiSignedAmount {
    @NotNull
    private final Sign sign;
    @NotNull
    private final DiAmount amount;

    @JsonCreator
    public DiSignedAmount(@NotNull @JsonProperty("sign") final Sign sign, @NotNull @JsonProperty("amount") final DiAmount amount) {
        this.sign = sign;
        this.amount = amount;
    }

    public static DiSignedAmount positive(@NotNull final DiAmount amount) {
        return new DiSignedAmount(Sign.POSITIVE, amount);
    }

    public static DiSignedAmount positive(final long value, @NotNull final DiUnit unit) {
        return new DiSignedAmount(Sign.POSITIVE, DiAmount.of(value, unit));
    }


    public static DiSignedAmount negative(@NotNull final DiAmount amount) {
        return new DiSignedAmount(Sign.NEGATIVE, amount);
    }

    public static DiSignedAmount negative(final long value, @NotNull final DiUnit unit) {
        return new DiSignedAmount(Sign.NEGATIVE, DiAmount.of(value, unit));
    }

    @NotNull
    public Sign getSign() {
        return sign;
    }

    @NotNull
    public DiAmount getAmount() {
        return amount;
    }

    public long toSignedValue(@NotNull final DiUnit unit) {
        return unit.convert(amount) * (sign == Sign.POSITIVE ? 1 : -1);
    }

    private enum Sign {
        POSITIVE,
        NEGATIVE
    }
}
