package ru.yandex.qe.dispenser.api.v1;

import java.util.Arrays;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DiYandexGroupType {
    DEPARTMENT("departments"),
    SERVICE("services"),
    SERVICEROLE("serviceroles"),
    WIKI("wiki"),
    ;

    @NotNull
    private final String plural;

    DiYandexGroupType(@NotNull final String plural) {
        this.plural = plural;
    }

    @NotNull
    public String getPlural() {
        return plural;
    }

    @Nullable
    public static DiYandexGroupType fromPlural(@NotNull final String plural) {
        return Arrays.stream(values()).filter(type -> type.getPlural().equals(plural)).findAny().orElse(null);
    }
}
