package ru.yandex.qe.dispenser.api.v1.field;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.fasterxml.jackson.core.type.TypeReference;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiPersonGroup;
import ru.yandex.qe.dispenser.api.v1.project.DiExtendedProject;

/**
 * Collection of {@link DiField}s for the {@link DiExtendedProject} DTO.
 */
public final class DiProjectFields {
    public static final DiField<Integer> ABC_SERVICE = new DiField.TypedField<>("abcServiceId", Integer.class);
    public static final DiField<DiPersonGroup> RESPONSIBLES = new DiField.TypedField<>("responsibles", DiPersonGroup.class);
    public static final DiField<DiPersonGroup> MEMBERS = new DiField.TypedField<>("members", DiPersonGroup.class);
    public static final DiField<Set<String>> ALL_MEMBERS = new DiField.TypeReferencedField<>("allMembers", new TypeReference<Set<String>>() {
    });
    public static final DiField<String> PARENT_PROJECT_KEY = new DiField.StringField("parentProjectKey");
    public static final DiField<Collection<String>> SUB_PROJECT_KEYS = new DiField.TypeReferencedField<>("subprojectKeys", new TypeReference<Collection<String>>() {
    });
    public static final DiField<DiExtendedProject> PARENT_PROJECT = new DiField.TypedField<>("parentProject", DiExtendedProject.class);
    public static final DiField<List<DiExtendedProject>> ANCESTORS = new DiField.TypeReferencedField<>("ancestors", new TypeReference<List<DiExtendedProject>>() {
    });
    public static final DiField<Set<DiExtendedProject.Permission>> PERMISSIONS = new DiField.TypeReferencedField<>("permissions", new TypeReference<Set<DiExtendedProject.Permission>>() {
    });
    public static final DiField<String> MAIL_LIST = new DiField.StringField("mailList");

    public static final Set<DiField<?>> ALL_FIELDS = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
            DiField.KEY,
            DiField.NAME,
            DiField.DESCRIPTION,
            ABC_SERVICE,
            RESPONSIBLES,
            MEMBERS,
            ALL_MEMBERS,
            PARENT_PROJECT_KEY,
            SUB_PROJECT_KEYS,
            PARENT_PROJECT,
            ANCESTORS,
            PERMISSIONS,
            MAIL_LIST
    )));

    private DiProjectFields() {
    }

    @NotNull
    public static DiField<?> getFieldByKey(final String key) {
        for (final DiField<?> field : ALL_FIELDS) {
            if (key.equals(field.getKey())) {
                return field;
            }
        }
        throw new IllegalArgumentException("No field with key = " + key);
    }
}
