package ru.yandex.qe.dispenser.api.v1.project;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiPersonGroup;
import ru.yandex.qe.dispenser.api.v1.field.DiField;
import ru.yandex.qe.dispenser.api.v1.field.DiFieldHolder;
import ru.yandex.qe.dispenser.api.v1.field.DiProjectFields;

/**
 * DTO for quota subject with customizable fields subset.
 * Quota subject is either Nirvana Project or ABC Service, depending on the Dispenser component.
 */
@ParametersAreNonnullByDefault
@JsonDeserialize(using = DiExtendedProject.Deserializer.class)
public class DiExtendedProject extends DiFieldHolder implements DiProjectFieldsHolder {

    public enum Permission {
        CAN_CREATE_QUOTA_REQUEST,
        CAN_VIEW_BOT_PREORDER_COSTS
    }

    public DiExtendedProject(final Map<DiField<?>, ?> values) {
        super(values);
    }

    @Nullable
    @Override
    public String getKey() {
        return getFieldValue(DiField.KEY);
    }

    @Nullable
    @Override
    public String getName() {
        return getFieldValue(DiField.NAME);
    }

    @Nullable
    @Override
    public String getDescription() {
        return getFieldValue(DiField.DESCRIPTION);
    }

    @Override
    public Integer getAbcServiceId() {
        return getFieldValue(DiProjectFields.ABC_SERVICE);
    }

    @Override
    @Nullable
    public DiPersonGroup getResponsibles() {
        return getFieldValue(DiProjectFields.RESPONSIBLES);
    }

    @Override
    @Nullable
    public DiPersonGroup getMembers() {
        return getFieldValue(DiProjectFields.MEMBERS);
    }

    @Override
    public String getParentProjectKey() {
        return getFieldValue(DiProjectFields.PARENT_PROJECT_KEY);
    }

    @Override
    @Nullable
    public Collection<String> getSubprojectKeys() {
        return getFieldValue(DiProjectFields.SUB_PROJECT_KEYS);
    }


    public Set<DiExtendedProject.Permission> getPermissions() {
        return getFieldValue(DiProjectFields.PERMISSIONS);
    }

    @Nullable
    public String getMailList() {
        return getFieldValue(DiProjectFields.MAIL_LIST);
    }

    @Nullable
    public Set<String> getAllMembers() {
        return getFieldValue(DiProjectFields.ALL_MEMBERS);
    }

    @Nullable
    public DiExtendedProject getParentProject() {
        return getFieldValue(DiProjectFields.PARENT_PROJECT);
    }

    @Nullable
    public List<DiExtendedProject> getAncestors() {
        return getFieldValue(DiProjectFields.ANCESTORS);
    }

    static final class Deserializer extends DiFieldHolder.Deserializer<DiExtendedProject> {
        @Nonnull
        @Override
        protected Collection<DiField<?>> getAllFields() {
            return DiProjectFields.ALL_FIELDS;
        }

        @Nonnull
        @Override
        protected DiExtendedProject create(final Map<DiField<?>, ?> values) {
            return new DiExtendedProject(values);
        }
    }

}
