package ru.yandex.qe.dispenser.api.v1.request.quota;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiAmount;
import ru.yandex.qe.dispenser.api.v1.DiResourcePreorderReasonType;

public abstract class BaseBody {
    protected final List<ChangeBody> changes;
    protected final String description;
    protected final String comment;
    protected final String calculations;
    protected final List<String> chartLinks;
    protected final String chartLinksAbsenceExplanation;
    protected final Map<String, String> additionalProperties;
    protected final DiResourcePreorderReasonType resourcePreorderReasonType;
    protected final Long goalId;
    protected final String summary;
    protected final Boolean importantRequest;

    protected BaseBody(final List<ChangeBody> changes, final String description, final String calculations, final String comment,
                       final List<String> chartLinks, final String chartLinksAbsenceExplanation,
                       final Map<String, String> additionalProperties, final DiResourcePreorderReasonType resourcePreorderReasonType,
                       final Long goalId, final String summary, final Boolean importantRequest) {
        this.changes = changes;
        this.description = description;
        this.calculations = calculations;
        this.comment = comment;
        this.chartLinks = chartLinks;
        this.chartLinksAbsenceExplanation = chartLinksAbsenceExplanation;
        this.additionalProperties = additionalProperties;
        this.resourcePreorderReasonType = resourcePreorderReasonType;
        this.goalId = goalId;
        this.summary = summary;
        this.importantRequest = importantRequest;
    }

    public List<ChangeBody> getChanges() {
        return changes;
    }

    public String getDescription() {
        return description;
    }

    public String getComment() {
        return comment;
    }

    public String getCalculations() {
        return calculations;
    }

    public List<String> getChartLinks() {
        return chartLinks;
    }

    public String getChartLinksAbsenceExplanation() {
        return chartLinksAbsenceExplanation;
    }

    public Map<String, String> getAdditionalProperties() {
        return additionalProperties;
    }

    public DiResourcePreorderReasonType getResourcePreorderReasonType() {
        return resourcePreorderReasonType;
    }

    public Long getGoalId() {
        return goalId;
    }

    public String getSummary() {
        return summary;
    }

    public Boolean getImportantRequest() {
        return importantRequest;
    }

    public static abstract class BaseBodyBuilder<B extends BaseBodyBuilder<B>> {
        @NotNull
        protected final List<ChangeBody> changes = new ArrayList<>();
        @Nullable
        protected String description;
        @Nullable
        protected String comment;
        @Nullable
        protected String calculations;
        @Nullable
        protected List<String> chartLinks;
        @Nullable
        protected String chartLinksAbsenceExplanation;
        @Nullable
        protected Map<String, String> additionalProperties;
        @Nullable
        protected Long goalId;
        @Nullable
        protected DiResourcePreorderReasonType resourcePreorderReasonType;
        @Nullable
        protected String summary;
        @Nullable
        protected Boolean importantRequest;

        @NotNull
        protected abstract B self();

        @NotNull
        public B changes(@NotNull final String serviceKey,
                         @NotNull final String resourceKey,
                         @Nullable final Long orderId,
                         @NotNull final Set<String> segments,
                         @NotNull final DiAmount amount) {
            changes.add(new ChangeBody(serviceKey, resourceKey, orderId, segments, amount));
            return self();
        }

        @NotNull
        public B changes(@NotNull final ChangeBody changeBody) {
            changes.add(changeBody);
            return self();
        }

        @NotNull
        public B description(@NotNull final String description) {
            this.description = description;
            return self();
        }

        @NotNull
        public B comment(@NotNull final String comment) {
            this.comment = comment;
            return self();
        }

        @NotNull
        public B calculations(@Nullable final String calculations) {
            this.calculations = calculations;
            return self();
        }

        @NotNull
        public B chartLink(@NotNull final String chartLink) {
            if (chartLinks == null) {
                chartLinks = new ArrayList<>();
            }
            chartLinks.add(chartLink);
            return self();
        }

        @NotNull
        public B chartLink(@NotNull final List<String> chartLinks) {
            this.chartLinks = new ArrayList<>(chartLinks);
            return self();
        }

        @NotNull
        public B chartLinksAbsenceExplanation(@Nullable final String chartLinksAbsenceExplanation) {
            this.chartLinksAbsenceExplanation = chartLinksAbsenceExplanation;
            return self();
        }

        @NotNull
        public B additionalProperties(@NotNull final Map<String, String> additionalProperties) {
            if (this.additionalProperties == null) {
                this.additionalProperties = new HashMap<>();
            }
            this.additionalProperties.putAll(additionalProperties);
            return self();
        }

        @NotNull
        public B replaceAdditionalProperties(@NotNull final Map<String, String> additionalProperties) {
            this.additionalProperties = additionalProperties;
            return self();
        }

        @NotNull
        public B resourcePreorderReasonType(@Nullable final DiResourcePreorderReasonType resourcePreorderReasonType) {
            this.resourcePreorderReasonType = resourcePreorderReasonType;
            return self();
        }

        @NotNull
        public B goalId(@Nullable final Long goalId) {
            this.goalId = goalId;
            return self();
        }

        @NotNull
        public B summary(@Nullable final String summary) {
            this.summary = summary;
            return self();
        }

        @NotNull
        public B importantRequest(@Nullable final Boolean importantRequest) {
            this.importantRequest = importantRequest;
            return self();
        }

    }
}
