package ru.yandex.qe.dispenser.api.v1.request.quota;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiAmount;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequest;
import ru.yandex.qe.dispenser.api.v1.DiQuotaKey;
import ru.yandex.qe.dispenser.api.v1.DiResourcePreorderReasonType;

public class Body extends BaseBody {
    @Nullable
    private final String projectKey;
    @Nullable
    private final String sourceProjectKey;
    @Nullable
    private final DiQuotaChangeRequest.Type type;

    @JsonCreator
    public Body(@Nullable @JsonProperty("projectKey") final String projectKey,
                @Nullable @JsonProperty("changes") final List<ChangeBody> changes,
                @Nullable @JsonProperty("description") final String description,
                @Nullable @JsonProperty("comment") final String comment,
                @Nullable @JsonProperty("calculations") final String calculations,
                @Nullable @JsonProperty("sourceProjectKey") final String sourceProjectKey,
                @Nullable @JsonProperty("type") final DiQuotaChangeRequest.Type type,
                @Nullable @JsonProperty("chartLinks") final List<String> chartLinks,
                @Nullable @JsonProperty("chartLinksAbsenceExplanation") final String chartLinksAbsenceExplanation,
                @Nullable @JsonProperty("additionalProperties") final Map<String, String> additionalProperties,
                @Nullable @JsonProperty("resourcePreorderReasonType") final DiResourcePreorderReasonType resourcePreorderReasonType,
                @Nullable @JsonProperty("goalId") final Long goalId,
                @Nullable @JsonProperty("summary") final String summary,
                @Nullable @JsonProperty("importantRequest") final Boolean importantRequest) {
        super(changes, description, calculations, comment, chartLinks, chartLinksAbsenceExplanation, additionalProperties,
                resourcePreorderReasonType, goalId, summary, importantRequest);
        this.projectKey = projectKey;
        this.type = type;
        this.sourceProjectKey = sourceProjectKey;

    }

    public Body(@NotNull final Body.BodyBuilder bodyBuilder) {
        this(bodyBuilder.projectKey, bodyBuilder.changes, bodyBuilder.description, bodyBuilder.comment,
                bodyBuilder.calculations, bodyBuilder.sourceProjectKey, bodyBuilder.type, bodyBuilder.chartLinks,
                bodyBuilder.chartLinksAbsenceExplanation, bodyBuilder.additionalProperties, bodyBuilder.resourcePreorderReasonType,
                bodyBuilder.goalId, bodyBuilder.summary, bodyBuilder.importantRequest);
    }

    @Nullable
    public String getProjectKey() {
        return projectKey;
    }

    @Nullable
    public String getSourceProjectKey() {
        return sourceProjectKey;
    }

    @Nullable
    public DiQuotaChangeRequest.Type getType() {
        return type;
    }

    public static class BodyBuilder extends BaseBodyBuilder<BodyBuilder> {
        @Nullable
        private String projectKey;
        @Nullable
        private String sourceProjectKey;
        @Nullable
        private DiQuotaChangeRequest.Type type;

        @NotNull
        public BodyBuilder projectKey(@NotNull final String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @NotNull
        public BodyBuilder sourceProjectKey(@NotNull final String projectKey) {
            this.sourceProjectKey = projectKey;
            return this;
        }

        @NotNull
        public BodyBuilder type(@NotNull final DiQuotaChangeRequest.Type type) {
            this.type = type;
            return this;
        }

        @NotNull
        @Override
        protected BodyBuilder self() {
            return this;
        }

        @NotNull
        public BodyBuilder changes(@NotNull final DiQuotaKey quotaKey,
                                   @Nullable final Long orderId,
                                   @NotNull final DiAmount amount) {
            changes.add(new ChangeBody(quotaKey.getServiceKey(), quotaKey.getResourceKey(), orderId, quotaKey.getSegmentKeys(), amount));
            projectKey = quotaKey.getProjectKey();
            return this;
        }

        @NotNull
        public Body build() {
            return new Body(this);
        }
    }
}
