package ru.yandex.qe.dispenser.api.v1.request.quota;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.api.v1.DiResourcePreorderReasonType;

import java.util.List;
import java.util.Map;

public class BodyUpdate extends BaseBody {
    @Nullable
    private final Map<Long, String> requestGoalAnswers;
    @Nullable
    private final String projectKey;

    @SuppressWarnings("ConstructorWithTooManyParameters")
    @JsonCreator
    public BodyUpdate(@Nullable @JsonProperty("changes") final List<ChangeBody> changes,
                      @Nullable @JsonProperty("description") final String description,
                      @Nullable @JsonProperty("comment") final String comment,
                      @Nullable @JsonProperty("calculations") final String calculations,
                      @Nullable @JsonProperty("chartLinks") final List<String> chartLinks,
                      @Nullable @JsonProperty("chartLinksAbsenceExplanation") final String chartLinksAbsenceExplanation,
                      @Nullable @JsonProperty("additionalProperties") final Map<String, String> additionalProperties,
                      @Nullable @JsonProperty("resourcePreorderReasonType") final DiResourcePreorderReasonType resourcePreorderReasonType,
                      @Nullable @JsonProperty("goalId") final Long goalId,
                      @Nullable @JsonProperty("requestGoalAnswers") final Map<Long, String> requestGoalAnswers,
                      @Nullable @JsonProperty("summary") final String summary,
                      @Nullable @JsonProperty("projectKey") String projectKey,
                      @Nullable @JsonProperty("importantRequest") final Boolean importantRequest) {
        super(changes, description, calculations, comment, chartLinks, chartLinksAbsenceExplanation, additionalProperties,
                resourcePreorderReasonType, goalId, summary, importantRequest);
        this.requestGoalAnswers = requestGoalAnswers;
        this.projectKey = projectKey;
    }

    public BodyUpdate(final BodyUpdateBuilder bodyBuilder) {
        this(bodyBuilder.changes, bodyBuilder.description, bodyBuilder.comment, bodyBuilder.calculations, bodyBuilder.chartLinks,
                bodyBuilder.chartLinksAbsenceExplanation, bodyBuilder.additionalProperties, bodyBuilder.resourcePreorderReasonType,
                bodyBuilder.goalId, bodyBuilder.requestGoalAnswers, bodyBuilder.summary, bodyBuilder.projectKey, bodyBuilder.importantRequest);
    }

    public @Nullable Map<Long, String> getRequestGoalAnswers() {
        return requestGoalAnswers;
    }

    @Nullable
    public String getProjectKey() {
        return projectKey;
    }

    public static class BodyUpdateBuilder extends BaseBodyBuilder<BodyUpdateBuilder> {

        @Nullable
        private Map<Long, String> requestGoalAnswers;

        @Nullable
        private String projectKey;

        @NotNull
        public BodyUpdateBuilder requestGoalAnswers(@NotNull final Map<Long, String> requestGoalAnswers) {
            this.requestGoalAnswers = requestGoalAnswers;
            return this;
        }

        @NotNull
        public BodyUpdateBuilder projectKey(@NotNull final String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @NotNull
        public BodyUpdate build() {
            return new BodyUpdate(this);
        }

        @NotNull
        @Override
        protected BodyUpdateBuilder self() {
            return this;
        }
    }
}
