package ru.yandex.qe.dispenser.api.v1.request.quota;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiAmount;

public class ChangeBody {
    @Nullable
    private final Long orderId;
    @Nullable
    private final String serviceKey;
    @Nullable
    private final String resourceKey;
    @Nullable
    private final Set<String> segmentKeys;
    @Nullable
    private final DiAmount amount;

    @JsonCreator
    public ChangeBody(@Nullable @JsonProperty("serviceKey") final String serviceKey,
                      @Nullable @JsonProperty("resourceKey") final String resourceKey,
                      @Nullable @JsonProperty("orderId") final Long orderId,
                      @Nullable @JsonProperty("segmentKeys") final Set<String> segmentKeys,
                      @Nullable @JsonProperty("amount") final DiAmount amount) {
        this.orderId = orderId;
        this.serviceKey = serviceKey;
        this.resourceKey = resourceKey;
        this.segmentKeys = segmentKeys;
        this.amount = amount;
    }

    @Nullable
    public Long getOrderId() {
        return orderId;
    }

    @Nullable
    public String getServiceKey() {
        return serviceKey;
    }

    @Nullable
    public String getResourceKey() {
        return resourceKey;
    }

    @Nullable
    public Set<String> getSegmentKeys() {
        return segmentKeys;
    }

    @Nullable
    public DiAmount getAmount() {
        return amount;
    }
}
