package ru.yandex.qe.dispenser.api.v1.request.unbalance;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.request.quota.ChangeBody;

/**
 * DiQuotaChangeRequestUnbalancedContext.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
public class DiQuotaChangeRequestUnbalancedContext {
    @Nullable
    private final Long campaignId;
    @Nullable
    private final String providerKey;
    @Nullable
    private final List<ChangeBody> changes;

    @JsonCreator
    public DiQuotaChangeRequestUnbalancedContext(@Nullable @JsonProperty("campaignId") Long campaignId,
                                                 @Nullable @JsonProperty("providerKey") String providerKey,
                                                 @Nullable @JsonProperty("changes") List<ChangeBody> changes) {
        this.campaignId = campaignId;
        this.providerKey = providerKey;
        this.changes = changes;
    }

    @Nullable
    public Long getCampaignId() {
        return campaignId;
    }

    @Nullable
    public String getProviderKey() {
        return providerKey;
    }

    @Nullable
    public List<ChangeBody> getChanges() {
        return changes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DiQuotaChangeRequestUnbalancedContext that = (DiQuotaChangeRequestUnbalancedContext) o;
        return Objects.equals(campaignId, that.campaignId) && Objects.equals(providerKey, that.providerKey)
                && Objects.equals(changes, that.changes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, providerKey, changes);
    }

    @Override
    public String toString() {
        return "DiQuotaChangeRequestUnbalancedContext{" +
                "campaignId=" + campaignId +
                ", providerKey='" + providerKey + '\'' +
                ", changes=" + changes +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long campaignId;
        private String providerKey;
        private List<ChangeBody> changes;

        public Builder campaignId(Long campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder providerKey(String providerKey) {
            this.providerKey = providerKey;
            return this;
        }

        public Builder changes(List<ChangeBody> changes) {
            this.changes = changes;
            return this;
        }

        public DiQuotaChangeRequestUnbalancedContext build() {
            return new DiQuotaChangeRequestUnbalancedContext(
                    campaignId,
                    providerKey,
                    changes
            );
        }
    }
}
