package ru.yandex.qe.dispenser.api.v1.response;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

public interface DiCursorPage<T> extends DiPage<T> {
    String CURSOR_QUERY_NAME = "cursor";

    default String[] extractQuery(final @NotNull String url) {
        return url.substring(url.indexOf("?") + 1).split("&");
    }

    default Map<String, String> extractQueryParamValues(@NotNull final String url,
                                                        @NotNull final String... names) {

        final HashSet<String> fieldNames = new HashSet<>(Arrays.asList(names));
        return Arrays.stream(extractQuery(url))
                .map(qv -> qv.split("="))
                .filter(qv -> fieldNames.contains(qv[0]))
                .collect(Collectors.toMap(qv -> qv[0], qv -> qv[1]));
    }

    default String extractQueryParamValue(@NotNull final String url,
                                          @NotNull final String name) {
        return Arrays.stream(extractQuery(url))
                .map(qv -> qv.split("="))
                .filter(qv -> name.equals(qv[0]))
                .findFirst()
                .map(qv -> qv[1])
                .orElse(null);
    }

    default String extractCursor(final String url) {
        return url != null
                ? extractQueryParamValue(url, CURSOR_QUERY_NAME)
                : null;
    }

    String cursor();
}
