package ru.yandex.qe.dispenser.api.v1.response;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.util.JsonDeserializerBase;
import ru.yandex.qe.dispenser.api.v1.DiProject;
import ru.yandex.qe.dispenser.api.v1.request.DiEntity;
import ru.yandex.qe.dispenser.api.v1.request.DiEntityOwnership;

import static ru.yandex.qe.dispenser.api.util.SerializationUtils.convertValue;

@JsonSerialize(using = DiEntityOwnershipResponse.Serializer.class)
@JsonDeserialize(using = DiEntityOwnershipResponse.Deserializer.class)
public final class DiEntityOwnershipResponse extends DiListResponse<DiEntityOwnership> {
    public DiEntityOwnershipResponse(@NotNull final Collection<DiEntityOwnership> result) {
        super(result);
    }

    @NotNull
    public Set<DiEntity> getEntities() {
        return stream().map(DiEntityOwnership::getEntity).collect(Collectors.toSet());
    }

    @NotNull
    public Set<DiProject> getProjects() {
        return stream().map(DiEntityOwnership::getProject).collect(Collectors.toSet());
    }

    static final class Serializer extends DiListResponse.Serializer<DiEntityOwnershipResponse> {
        @Override
        public void serialize(@NotNull final DiEntityOwnershipResponse response,
                              @NotNull final JsonGenerator jg,
                              @NotNull final SerializerProvider sp) throws IOException {
            super.serialize(response, jg, sp);
        }
    }

    static final class Deserializer extends JsonDeserializerBase<DiEntityOwnershipResponse> {
        @NotNull
        @Override
        public DiEntityOwnershipResponse deserialize(@NotNull final JsonParser jp,
                                                     @NotNull final DeserializationContext dc) throws IOException {
            return new DiEntityOwnershipResponse(convertValue(toJson(jp).get("result"), new TypeReference<Collection<DiEntityOwnership>>() {
            }));
        }
    }
}
