package ru.yandex.qe.dispenser.api.v1.response;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.request.DiOperation;

public class DiOperationResult {
    @NotNull
    private final DiOperation<?> operation;
    private final boolean isSuccess;
    @Nullable
    private final String errorReason;

    public DiOperationResult(@NotNull final DiOperation<?> operation, final boolean isSuccess, @Nullable final String errorReason) {
        this.operation = operation;
        this.isSuccess = isSuccess;
        this.errorReason = errorReason;
    }

    @NotNull
    public DiOperation<?> getOperation() {
        return operation;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    @Nullable
    public String getErrorReason() {
        return errorReason;
    }
}
