package ru.yandex.qe.dispenser.client.v1;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiOAuthToken {
    @NotNull
    private final String value;

    @NotNull
    public static DiOAuthToken of(@NotNull final String tokenValue) {
        return new DiOAuthToken(tokenValue);
    }

    private DiOAuthToken(@NotNull final String value) {
        this.value = value;
    }

    @NotNull
    public String getValue() {
        return value;
    }

    @Override
    public boolean equals(@Nullable final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        return value.equals(((DiOAuthToken) o).value);
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }
}
