package ru.yandex.qe.dispenser.client.v1;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiPerformer;

public final class DiPerson {
    @NotNull
    private final String login;

    public static DiPerson login(@NotNull final String login) {
        return new DiPerson(login);
    }

    public static DiPerson oauthToken(@NotNull final String tokenValue) {
        throw new UnsupportedOperationException("Person authentication by OAuth token is not supported yet");
    }

    private DiPerson(@NotNull final String login) {
        this.login = login;
    }

    @NotNull
    public String getLogin() {
        return login;
    }

    @NotNull
    public DiPerformer chooses(@NotNull final String projectKey) {
        return DiPerformer.login(login).chooses(projectKey);
    }

    @NotNull
    @Override
    public String toString() {
        return getLogin();
    }
}
