package ru.yandex.qe.dispenser.client.v1;

import java.util.List;

import org.jetbrains.annotations.NotNull;

import org.jetbrains.annotations.Nullable;
import ru.yandex.qe.dispenser.api.v1.DiBotSyncStatus;
import ru.yandex.qe.dispenser.api.v1.DiCheck;
import ru.yandex.qe.dispenser.api.v1.DiDispenserSettings;
import ru.yandex.qe.dispenser.api.v1.DiEntitySpec;
import ru.yandex.qe.dispenser.api.v1.DiPermission;
import ru.yandex.qe.dispenser.api.v1.DiPersonInfo;
import ru.yandex.qe.dispenser.api.v1.DiProject;
import ru.yandex.qe.dispenser.api.v1.DiProperty;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequest;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeStatistic;
import ru.yandex.qe.dispenser.api.v1.DiQuotaLightView;
import ru.yandex.qe.dispenser.api.v1.DiQuotaMaxDeltaUpdate;
import ru.yandex.qe.dispenser.api.v1.DiQuotaMaxUpdate;
import ru.yandex.qe.dispenser.api.v1.DiResource;
import ru.yandex.qe.dispenser.api.v1.DiResourceGroup;
import ru.yandex.qe.dispenser.api.v1.DiSegment;
import ru.yandex.qe.dispenser.api.v1.DiSegmentation;
import ru.yandex.qe.dispenser.api.v1.DiService;
import ru.yandex.qe.dispenser.api.v1.field.DiField;
import ru.yandex.qe.dispenser.api.v1.project.DiExtendedProject;
import ru.yandex.qe.dispenser.api.v1.request.DiProcessingMode;
import ru.yandex.qe.dispenser.api.v1.request.quota.Body;
import ru.yandex.qe.dispenser.api.v1.request.quota.BodyUpdate;
import ru.yandex.qe.dispenser.api.v1.response.DiListResponse;
import ru.yandex.qe.dispenser.api.v1.response.DiQuotaGetResponse;
import ru.yandex.qe.dispenser.client.QueryableRequestBuilder;
import ru.yandex.qe.dispenser.client.RequestBuilder;
import ru.yandex.qe.dispenser.client.UsedBy;
import ru.yandex.qe.dispenser.client.v1.builder.BatchQuotaChangeRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.BatchWeakQuotaChangeRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.CreateRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.DeleteRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.DispenserSettingsModificationRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetEntitiesRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetEntityOwnershipsRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetEntitySpecsRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetProjectMetaRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetProjectsRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetQuotasRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.GetWeakQuotasRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.PersonGroupModificationRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.ProjectModificationRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.QuotaMaxUpdateRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.ResourceModificationRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.ServiceModificationRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.SimplePersonRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.SyncActualQuotasRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.SyncQuotasRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.SyncRawQuotasRequestBuilder;
import ru.yandex.qe.dispenser.client.v1.builder.UpdateEntitiesRequestBuilder;

public interface Dispenser {
    @NotNull
    DispenserSettingsApi dispenserSettings();

    @NotNull
    ProjectApi projects();

    @NotNull
    @Deprecated
    @UsedBy(UsedBy.NIRVANA)
    CrudProjectApi project(@NotNull String projectKey);

    @NotNull
    ServiceApi service(@NotNull String serviceKey);

    @NotNull
    QuotaApi quotas();

    @NotNull
    EntitySpecApi entitySpecifications();

    @NotNull
    GetEntitiesRequestBuilder<?> getEntities();

    @NotNull
    UpdateEntitiesRequestBuilder updateEntities();

    @NotNull
    GetEntityOwnershipsRequestBuilder<?> getEntityOwnerships();

    @NotNull
    WeakQuotaApi weakQuotas();

    @NotNull
    Dispenser.PersonApi persons();

    @NotNull
    Dispenser.PermissionApi permission();

    @NotNull
    Dispenser.SegmentationApi segmentations();

    @NotNull
    QuotaChangeRequestApi quotaChangeRequests();

    @NotNull
    Dispenser.PropertyApi properties();

    @NotNull
    Dispenser.BotSyncStatusApi botSyncStatus();

    @Deprecated
    interface CrudProjectApi extends CrudApiOld<DiProject, ProjectModificationRequestBuilder> {
        @NotNull
        PersonGroupModificationRequestBuilder<DiProject> members();

        @NotNull
        PersonGroupModificationRequestBuilder<DiProject> responsibles();

        ItemsCrudApi<DiCheck, DiCheck.Body, ItemCrudApi<DiCheck, DiCheck.Body>> checks();
    }

    interface DispenserSettingsApi extends CrudApiOld<DiDispenserSettings, DispenserSettingsModificationRequestBuilder> {
    }

    interface ProjectApi extends CrudApi<DiProject, String, ProjectModificationRequestBuilder> {
        @NotNull
        GetProjectsRequestBuilder<DiProject> get();

        @NotNull
        GetProjectsRequestBuilder<DiExtendedProject> getWithFields(@NotNull DiField<?>... fields);

        @NotNull
        GetProjectMetaRequestBuilder<?> getMeta();
    }

    interface ServiceApi extends CrudApiOld<DiService, ServiceModificationRequestBuilder> {
        @NotNull
        PersonGroupModificationRequestBuilder<DiService> admins();

        @NotNull
        PersonGroupModificationRequestBuilder<DiService> trustees();

        @NotNull
        ServiceResourceApi resource(@NotNull String resourceKey);

        @NotNull
        SyncStateApi syncState();

        @NotNull
        UpdateMaxApi updateMax();

        @NotNull
        ResourceGroupApi resourceGroups();

        @NotNull
        RequestBuilder<DiListResponse<DiResource>> resources();

        @NotNull
        RequestBuilder<DiListResponse<DiResource>> resourcesByGroups(@NotNull String... groups);
    }

    interface ServiceResourceApi extends CrudApiOld<DiResource, ResourceModificationRequestBuilder> {
        @NotNull
        ResourceSegmentaionApi segmentations();
    }

    interface EntitySpecApi {
        @NotNull
        GetEntitySpecsRequestBuilder get();

        // TODO: new CRUD API
        @NotNull
        @Deprecated
        RequestBuilder<DiEntitySpec> get(@NotNull final String serviceKey, @NotNull final String entitySpecKey);
    }

    interface SyncStateApi {
        @NotNull
        SyncQuotasRequestBuilder quotas();

        @NotNull
        SyncActualQuotasRequestBuilder actualQuotas();

        @NotNull
        SyncRawQuotasRequestBuilder rawQuotas();
    }

    interface UpdateMaxApi {
        @NotNull
        QuotaMaxUpdateRequestBuilder<DiQuotaMaxUpdate> quotas();

        @NotNull
        QuotaMaxUpdateRequestBuilder<DiQuotaMaxDeltaUpdate> deltas();
    }

    interface QuotaApi {
        @NotNull
        GetQuotasRequestBuilder<DiQuotaGetResponse, ?> get();

        @NotNull
        GetQuotasRequestBuilder<DiListResponse<DiQuotaLightView>, ?> getLightViews();

        @NotNull
        default BatchQuotaChangeRequestBuilder changeInService(@NotNull final String serviceKey) {
            return changeInService(serviceKey, DiProcessingMode.ROLLBACK_ON_ERROR);
        }

        @NotNull
        BatchQuotaChangeRequestBuilder changeInService(@NotNull String serviceKey, @NotNull DiProcessingMode mode);
    }

    interface WeakQuotaApi {
        @NotNull
        GetWeakQuotasRequestBuilder<?> get();

        @NotNull
        BatchWeakQuotaChangeRequestBuilder changeInService(@NotNull final String serviceKey, @NotNull final String entitySpecId);
    }

    interface PersonApi {
        QueryableRequestBuilder<DiPersonInfo> getInfo();

        default RequestBuilder<DiPersonInfo> getInfoFor(@NotNull final String login) {
            return getInfo().query("login", login);
        }
    }

    interface PermissionApi {
        QueryableRequestBuilder<DiPermission> get();

        default RequestBuilder<DiPermission> getFor(@NotNull final String login) {
            return get().query("login", login);
        }
    }

    interface ItemsCrudApi<T, B, I extends ItemCrudApi<T, B>> {
        @NotNull
        CreateRequestBuilder<T> create(final B itemBody);

        @NotNull
        RequestBuilder<DiListResponse<T>> get();

        @NotNull
        I byKey(String key);
    }

    interface ItemCrudApi<T, B> {
        @NotNull
        CreateRequestBuilder<T> update(final B itemBody);

        @NotNull
        DeleteRequestBuilder<T> delete();

        @NotNull
        RequestBuilder<T> get();
    }

    interface SegmentationItemApi extends ItemCrudApi<DiSegmentation, DiSegmentation> {
        SegmentApi segments();
    }

    interface SegmentationApi extends ItemsCrudApi<DiSegmentation, DiSegmentation, SegmentationItemApi> {
    }

    interface SegmentApi extends ItemsCrudApi<DiSegment, DiSegment, ItemCrudApi<DiSegment, DiSegment>> {
    }

    interface ResourceSegmentaionApi {
        @NotNull
        CreateRequestBuilder<List<DiSegmentation>> update(final List<DiSegmentation> segmentationList);

        @NotNull
        RequestBuilder<List<DiSegmentation>> get();
    }

    interface ResourceGroupApi extends ItemsCrudApi<DiResourceGroup, DiResourceGroup, ItemCrudApi<DiResourceGroup, DiResourceGroup>> {
    }

    interface QuotaChangeRequestItemApi {
        SimplePersonRequestBuilder<DiQuotaChangeRequest> setStatus(DiQuotaChangeRequest.Status status);

        SimplePersonRequestBuilder<DiQuotaChangeRequest> setStatus(DiQuotaChangeRequest.Status status, boolean suppressSummon);

        SimplePersonRequestBuilder<DiQuotaChangeRequest> createTicket();

        @NotNull
        SimplePersonRequestBuilder<DiQuotaChangeRequest> update(final BodyUpdate bodyUpdate);

        @NotNull
        SimplePersonRequestBuilder<DiQuotaChangeRequest> update(final BodyUpdate bodyUpdate, final boolean suppressSummon);

        @NotNull
        RequestBuilder<DiQuotaChangeRequest> get();
    }

    interface QuotaChangeRequestApi {
        @NotNull
        CreateRequestBuilder<DiListResponse<DiQuotaChangeRequest>> create(final Body itemBody, @Nullable Long campaignId);

        @NotNull
        CreateRequestBuilder<DiListResponse<DiQuotaChangeRequest>> batchCreate(final List<Body> itemBodies, @Nullable Long campaignId);

        @NotNull
        QuotaChangeRequestItemApi byId(long id);

        @NotNull
        QueryableRequestBuilder<DiListResponse<DiQuotaChangeRequest>> get();

        @NotNull
        QueryableRequestBuilder<DiQuotaChangeStatistic> getStatistic();
    }

    interface PropertyApi {
        @NotNull
        RequestBuilder<DiProperty> getProperty(final String entityKey, final String propertyKey);

        @NotNull
        RequestBuilder<DiListResponse<DiProperty>> getProperties(final String entityKey);

        <T> @NotNull SimplePersonRequestBuilder<DiProperty> setProperty(final String entityKey, final String propertyKey,
                                                                        final T value);

        @NotNull
        SimplePersonRequestBuilder<Boolean> deleteProperty(final String entityKey, final String propertyKey);
    }

    interface BotSyncStatusApi {
        QueryableRequestBuilder<DiBotSyncStatus> get();
    }

    @NotNull
    ResourceApi resource();

    interface ResourceApi {
        @NotNull
        QueryableRequestBuilder<DiListResponse<DiResource>> get();
    }
}
