package ru.yandex.qe.dispenser.client.v1.builder;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiPerformer;
import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeCause;
import ru.yandex.qe.dispenser.api.v1.request.DiEntity;
import ru.yandex.qe.dispenser.api.v1.request.DiEntityReference;
import ru.yandex.qe.dispenser.api.v1.request.DiEntityUsage;
import ru.yandex.qe.dispenser.api.v1.request.DiResourceAmount;
import ru.yandex.qe.dispenser.api.v1.response.DiQuotaChangeResponse;
import ru.yandex.qe.dispenser.client.RequestBuilder;

public interface BatchQuotaChangeRequestBuilder extends RequestBuilder<DiQuotaChangeResponse> {
    @NotNull
    default BatchQuotaChangeRequestBuilder acquireResource(@NotNull final DiResourceAmount amount, @NotNull final DiPerformer performer) {
        return acquireResource(amount, performer, DiQuotaChangeCause.forceAcqireResource().build());
    }

    @NotNull
    BatchQuotaChangeRequestBuilder acquireResource(@NotNull DiResourceAmount amount,
                                                   @NotNull DiPerformer performer,
                                                   @NotNull DiQuotaChangeCause cause);

    @NotNull
    default BatchQuotaChangeRequestBuilder acquireResources(@NotNull final Iterable<DiResourceAmount> amounts, @NotNull final DiPerformer performer) {
        amounts.forEach(amount -> acquireResource(amount, performer));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder acquireResources(@NotNull final Iterable<DiResourceAmount> amounts, @NotNull final DiPerformer performer, @NotNull final DiQuotaChangeCause cause) {
        amounts.forEach(amount -> acquireResource(amount, performer, cause));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseResource(@NotNull final DiResourceAmount amount, @NotNull final DiPerformer performer) {
        return releaseResource(amount, performer, DiQuotaChangeCause.releaseResource().build());
    }

    @NotNull
    BatchQuotaChangeRequestBuilder releaseResource(@NotNull DiResourceAmount amount, @NotNull DiPerformer performer, @NotNull DiQuotaChangeCause cause);

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseResources(@NotNull final Iterable<DiResourceAmount> amounts, @NotNull final DiPerformer performer) {
        amounts.forEach(amount -> releaseResource(amount, performer));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseResources(@NotNull final Iterable<DiResourceAmount> amounts, @NotNull final DiPerformer performer, @NotNull final DiQuotaChangeCause cause) {
        amounts.forEach(amount -> releaseResource(amount, performer, cause));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder createEntity(@NotNull final DiEntity entity, @NotNull final DiPerformer performer) {
        return createEntity(entity, performer, DiQuotaChangeCause.createEntity(entity, performer).build());
    }

    @NotNull
    BatchQuotaChangeRequestBuilder createEntity(@NotNull DiEntity entity, @NotNull DiPerformer performer, @NotNull DiQuotaChangeCause cause);

    @NotNull
    default BatchQuotaChangeRequestBuilder createEntities(@NotNull final Iterable<DiEntity> entities, @NotNull final DiPerformer performer) {
        entities.forEach(e -> createEntity(e, performer));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder createEntities(@NotNull final Iterable<DiEntity> entities, @NotNull final DiPerformer performer, @NotNull final DiQuotaChangeCause cause) {
        entities.forEach(e -> createEntity(e, performer, cause));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseEntity(@NotNull final DiEntityReference release) {
        return releaseEntity(release, DiQuotaChangeCause.releaseEntity(release).build());
    }

    @NotNull
    BatchQuotaChangeRequestBuilder releaseEntity(@NotNull DiEntityReference release, @NotNull DiQuotaChangeCause cause);

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseEntities(@NotNull final Iterable<? extends DiEntityReference> releases) {
        releases.forEach(this::releaseEntity);
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseEntities(@NotNull final Iterable<? extends DiEntityReference> releases, @NotNull final DiQuotaChangeCause cause) {
        releases.forEach(e -> releaseEntity(e, cause));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder shareEntity(@NotNull final DiEntityUsage acquireUsage, @NotNull final DiPerformer performer) {
        return shareEntity(acquireUsage, performer, DiQuotaChangeCause.shareEntity(acquireUsage, performer).build());
    }

    @NotNull
    BatchQuotaChangeRequestBuilder shareEntity(@NotNull DiEntityUsage acquireUsage, @NotNull DiPerformer performer, @NotNull DiQuotaChangeCause cause);

    @NotNull
    default BatchQuotaChangeRequestBuilder shareEntities(@NotNull final Iterable<DiEntityUsage> usages, @NotNull final DiPerformer performer) {
        usages.forEach(u -> shareEntity(u, performer));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder shareEntities(@NotNull final Iterable<DiEntityUsage> usages, @NotNull final DiPerformer performer, @NotNull final DiQuotaChangeCause cause) {
        usages.forEach(u -> shareEntity(u, performer, cause));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseEntitySharing(@NotNull final DiEntityUsage releaseUsage, @NotNull final DiPerformer performer) {
        return releaseEntitySharing(releaseUsage, performer, DiQuotaChangeCause.releaseEntitySharing(releaseUsage, performer).build());
    }

    @NotNull
    BatchQuotaChangeRequestBuilder releaseEntitySharing(@NotNull DiEntityUsage releaseUsage, @NotNull DiPerformer performer, @NotNull DiQuotaChangeCause cause);

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseEntitiesSharing(@NotNull final Iterable<DiEntityUsage> releaseUsages, @NotNull final DiPerformer performer) {
        releaseUsages.forEach(u -> releaseEntitySharing(u, performer));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseEntitiesSharing(@NotNull final Iterable<DiEntityUsage> releaseUsages, @NotNull final DiPerformer performer, @NotNull final DiQuotaChangeCause cause) {
        releaseUsages.forEach(u -> releaseEntitySharing(u, performer, cause));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseAllEntitySharings(@NotNull final DiEntityReference entity, @NotNull final DiPerformer performer) {
        return releaseAllEntitySharings(entity, performer, DiQuotaChangeCause.releaseAllEntitySharings(entity, performer).build());
    }

    @NotNull
    BatchQuotaChangeRequestBuilder releaseAllEntitySharings(@NotNull DiEntityReference entity, @NotNull DiPerformer performer, @NotNull DiQuotaChangeCause cause);

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseAllEntitiesSharings(@NotNull final Iterable<? extends DiEntityReference> entities, @NotNull final DiPerformer performer) {
        entities.forEach(e -> releaseAllEntitySharings(e, performer));
        return this;
    }

    @NotNull
    default BatchQuotaChangeRequestBuilder releaseAllEntitiesSharings(@NotNull final Iterable<? extends DiEntityReference> entities, @NotNull final DiPerformer performer, @NotNull final DiQuotaChangeCause cause) {
        entities.forEach(e -> releaseAllEntitySharings(e, performer, cause));
        return this;
    }

    @NotNull
    BatchQuotaChangeRequestBuilder withReqId(@NotNull String reqId);
}
